/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;

public class TeamPlugin
extends AbstractPlugin {
    public static final String INVALID_REFERENCE_ASSIGNED_BY_MODEL = "INVALID_REFERENCE_ASSIGNED_BY_MODEL";
    public static final String NO_PROCESS_ASSIGNED = "NO_PROCESS_ASSIGNED";
    private ItemCollection documentContext;
    private static Logger logger = Logger.getLogger(TeamPlugin.class.getName());
    private Map<String, ItemCollection> entityCache = null;

    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        this.entityCache = new HashMap<String, ItemCollection>();
    }

    public ItemCollection run(ItemCollection workItem, ItemCollection documentActivity) throws PluginException {
        String aID;
        ItemCollection entity;
        ArrayList<String> verifiedRefList;
        ItemCollection entity2;
        this.documentContext = workItem;
        List oldUnqiueIdRefList = workItem.getItemValue("$uniqueidref");
        ArrayList<String> newUnqiueIDRefList = null;
        List processRefList = null;
        List spaceRefList = null;
        if (!workItem.hasItem("process.ref") && workItem.hasItem("txtprocessref")) {
            workItem.setItemValueUnique("process.ref", (Object)workItem.getItemValue("txtprocessref"));
        }
        if (!workItem.hasItem("space.ref") && workItem.hasItem("txtspaceref")) {
            workItem.setItemValueUnique("space.ref", (Object)workItem.getItemValue("txtspaceref"));
        }
        if (!workItem.hasItem("process.ref") && !oldUnqiueIdRefList.isEmpty()) {
            processRefList = workItem.getItemValue("process.ref");
            for (Object aUniqueID : oldUnqiueIdRefList) {
                if (aUniqueID == null || ((String)aUniqueID).isEmpty() || (entity2 = this.findEntity((String)aUniqueID)) == null || !"process".equals(entity2.getItemValueString("type"))) continue;
                processRefList.add(entity2.getItemValueString("$uniqueid"));
            }
            workItem.setItemValueUnique("process.ref", (Object)processRefList);
        } else if (workItem.hasItem("process.ref")) {
            processRefList = workItem.getItemValue("process.ref");
            verifiedRefList = new ArrayList();
            for (String aUniqueID : processRefList) {
                if (aUniqueID == null || aUniqueID.isEmpty()) continue;
                entity = this.findEntity(aUniqueID);
                if (entity == null && (entity = this.findRefByName(aUniqueID, "process")) != null) {
                    aID = entity.getItemValueString("$uniqueid");
                    logger.info("[TeamPlugin] processRefName '" + aUniqueID + "' translated into '" + aID + "'");
                    aUniqueID = aID;
                }
                if (entity == null || !"process".equals(entity.getItemValueString("type"))) continue;
                verifiedRefList.add(aUniqueID);
            }
            workItem.setItemValueUnique("process.ref", verifiedRefList);
        }
        if (!workItem.hasItem("space.ref") && !oldUnqiueIdRefList.isEmpty()) {
            spaceRefList = workItem.getItemValue("space.ref");
            for (Object aUniqueID : oldUnqiueIdRefList) {
                entity2 = this.findEntity((String)aUniqueID);
                if (entity2 == null || !"space".equals(entity2.getType()) && !"spacearchive".equals(entity2.getType())) continue;
                spaceRefList.add(entity2.getItemValueString("$uniqueid"));
            }
            workItem.setItemValueUnique("space.ref", (Object)spaceRefList);
        } else if (workItem.hasItem("space.ref")) {
            processRefList = workItem.getItemValue("space.ref");
            verifiedRefList = new ArrayList<String>();
            for (String aUniqueID : processRefList) {
                entity = this.findEntity(aUniqueID);
                if (entity == null && (entity = this.findRefByName(aUniqueID, "space")) != null) {
                    aID = entity.getItemValueString("$uniqueid");
                    logger.info("[TeamPlugin] spaceRefName '" + aUniqueID + "' translated into '" + aID + "'");
                    aUniqueID = aID;
                }
                if (entity == null || !"space".equals(entity.getType()) && !"spacearchive".equals(entity.getType())) continue;
                verifiedRefList.add(aUniqueID);
            }
            workItem.setItemValueUnique("space.ref", verifiedRefList);
        }
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(documentActivity, "item", workItem);
        if (evalItemCollection != null) {
            String sRef = this.fetchRefFromActivity("process", evalItemCollection);
            if (sRef != null && !sRef.isEmpty()) {
                logger.fine("[TeamPlugin] Updating process reference based on model information: " + sRef);
                workItem.setItemValueUnique("process.ref", (Object)sRef);
            }
            if ((sRef = this.fetchRefFromActivity("space", evalItemCollection)) != null && !sRef.isEmpty()) {
                logger.fine("[TeamPlugin] Updating space reference based on model information: " + sRef);
                workItem.setItemValueUnique("space.ref", (Object)sRef);
            }
        }
        processRefList = workItem.getItemValue("process.ref");
        spaceRefList = workItem.getItemValue("space.ref");
        newUnqiueIDRefList = new ArrayList<String>();
        newUnqiueIDRefList.addAll(processRefList);
        newUnqiueIDRefList.addAll(spaceRefList);
        for (String aUniqueID : oldUnqiueIdRefList) {
            entity = this.findEntity(aUniqueID);
            if (entity != null && "process".equals(entity.getItemValueString("type")) && !processRefList.contains(aUniqueID)) {
                logger.fine("remove deprecated processRef " + aUniqueID);
                continue;
            }
            if (entity != null && ("space".equals(entity.getType()) || "spacearchive".equals(entity.getType())) && !spaceRefList.contains(aUniqueID)) {
                logger.fine("remove deprecated spaceRef " + aUniqueID);
                continue;
            }
            if (newUnqiueIDRefList.contains(aUniqueID)) continue;
            newUnqiueIDRefList.add(aUniqueID);
        }
        workItem.removeItem("space.team");
        workItem.removeItem("space.manager");
        workItem.removeItem("space.assist");
        workItem.removeItem("space.team.label");
        workItem.removeItem("space.manager.label");
        workItem.removeItem("space.assist.label");
        workItem.removeItem("process.team");
        workItem.removeItem("process.manager");
        workItem.removeItem("process.assist");
        workItem.removeItem("process.team.label");
        workItem.removeItem("process.manager.label");
        workItem.removeItem("process.assist.label");
        workItem.removeItem("process.name");
        workItem.removeItem("space.name");
        workItem.removeItem("$uniqueidref");
        workItem.setItemValueUnique("$uniqueidref", newUnqiueIDRefList);
        logger.fine("Updated $UniqueIdRef: " + newUnqiueIDRefList);
        for (String aUnqiueID : newUnqiueIDRefList) {
            entity = this.findEntity(aUnqiueID);
            if (entity == null) continue;
            String parentType = entity.getItemValueString("type");
            if ("process".equals(parentType)) {
                workItem.appendItemValueUnique("process.assist", (Object)entity.getItemValue("process.assist"));
                workItem.appendItemValueUnique("process.team", (Object)entity.getItemValue("process.team"));
                workItem.appendItemValueUnique("process.manager", (Object)entity.getItemValue("process.manager"));
                workItem.appendItemValueUnique("process.assist.label", (Object)entity.getItemValue("process.assist.label"));
                workItem.appendItemValueUnique("process.team.label", (Object)entity.getItemValue("process.team.label"));
                workItem.appendItemValueUnique("process.manager.label", (Object)entity.getItemValue("process.manager.label"));
                workItem.appendItemValueUnique("process.name", (Object)entity.getItemValue("name"));
            }
            if (!"space".equals(parentType) && !"spacearchive".equals(parentType)) continue;
            workItem.appendItemValueUnique("space.assist", (Object)entity.getItemValue("space.assist"));
            workItem.appendItemValueUnique("space.team", (Object)entity.getItemValue("space.team"));
            workItem.appendItemValueUnique("space.manager", (Object)entity.getItemValue("space.manager"));
            workItem.appendItemValueUnique("space.assist.label", (Object)entity.getItemValue("space.assist.label"));
            workItem.appendItemValueUnique("space.team.label", (Object)entity.getItemValue("space.team.label"));
            workItem.appendItemValueUnique("space.manager.label", (Object)entity.getItemValue("space.manager.label"));
            workItem.appendItemValueUnique("space.name", (Object)entity.getItemValue("space.name"));
        }
        workItem.replaceItemValue("namSpaceTeam", (Object)workItem.getItemValue("space.team"));
        workItem.replaceItemValue("namSpaceManager", (Object)workItem.getItemValue("space.manager"));
        workItem.replaceItemValue("namSpaceAssist", (Object)workItem.getItemValue("space.assist"));
        workItem.replaceItemValue("namProcessTeam", (Object)workItem.getItemValue("process.team"));
        workItem.replaceItemValue("namProcessManager", (Object)workItem.getItemValue("process.manager"));
        workItem.replaceItemValue("namProcessAssist", (Object)workItem.getItemValue("process.assist"));
        workItem.replaceItemValue("txtProcessName", (Object)workItem.getItemValue("process.name"));
        workItem.replaceItemValue("txtSpaceName", (Object)workItem.getItemValue("space.name"));
        workItem.replaceItemValue("txtSpaceNameNode", (Object)workItem.getItemValue("space.name"));
        workItem.replaceItemValue("txtProcessRef", (Object)workItem.getItemValue("process.ref"));
        workItem.replaceItemValue("txtSpaceRef", (Object)workItem.getItemValue("space.ref"));
        this.documentContext.removeItem("space");
        this.documentContext.removeItem("process");
        return this.documentContext;
    }

    public ItemCollection findEntity(String id) {
        ItemCollection entity = this.entityCache.get(id);
        if (entity == null) {
            entity = this.getWorkflowService().getDocumentService().load(id);
            if (entity == null) {
                entity = new ItemCollection();
            }
            this.entityCache.put(id, entity);
        }
        if (entity.getItemValueString("$uniqueid").isEmpty()) {
            return null;
        }
        return entity;
    }

    private String fetchRefFromActivity(String type, ItemCollection evalItemCollection) throws PluginException {
        String sRef = null;
        String aActivityRefName = evalItemCollection.getItemValueString(type);
        if (!"".equals(aActivityRefName)) {
            ItemCollection entity = this.getWorkflowService().getDocumentService().load(aActivityRefName);
            if (entity != null && !type.equals(entity.getItemValueString("type"))) {
                entity = null;
            }
            if (entity == null) {
                entity = this.findRefByName(aActivityRefName, type);
            }
            if (entity != null) {
                sRef = entity.getItemValueString("$uniqueid");
                logger.fine("[TeamPlugin] found ref from Activity for: " + aActivityRefName);
            } else {
                throw new PluginException(TeamPlugin.class.getSimpleName(), INVALID_REFERENCE_ASSIGNED_BY_MODEL, type + " '" + aActivityRefName + "' defined by the current model can not be found!");
            }
        }
        return sRef;
    }

    private ItemCollection findRefByName(String aName, String type) {
        block5: {
            if (type == null || aName == null) {
                return null;
            }
            String sQuery = "(type:\"" + type + "\" OR type:\"" + type + "archive\") AND (name:\"" + aName + "\" OR txtname:\"" + aName + "\")";
            try {
                List col = this.getWorkflowService().getDocumentService().find(sQuery, 2, 0);
                if (col.size() == 0) {
                    logger.warning("findRefByName '" + aName + "' not found!");
                    break block5;
                }
                if (col.size() > 1) {
                    logger.warning("findRefByName '" + aName + "' is ambiguous!");
                    break block5;
                }
                ItemCollection entity = (ItemCollection)col.iterator().next();
                this.entityCache.put(entity.getItemValueString("$uniqueid"), entity);
                return entity;
            }
            catch (QueryException e) {
                logger.warning("findRefByName - invalid query: " + e.getMessage());
            }
        }
        return null;
    }
}

