/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.plugins.AbstractPlugin;

@Stateless
public class TeamRoleWildcardAdapter {
    private static Logger logger = Logger.getLogger(AbstractPlugin.class.getName());

    public void onEvent(@Observes TextEvent event) {
        ArrayList<String> textList = new ArrayList<String>();
        String role = event.getText();
        ItemCollection documentContext = event.getDocument();
        String regex = "^(" + Pattern.quote("{space:?:") + ".*|" + Pattern.quote("{process:?:") + ".*)";
        if (role.matches(regex)) {
            List orgunitIDs;
            logger.fine("replace role wildcards ...");
            if (role.startsWith("{space:?:")) {
                orgunitIDs = documentContext.getItemValue("space.ref");
                for (String id : orgunitIDs) {
                    textList.add(role.replace(":?:", ":" + id + ":"));
                }
            }
            if (role.startsWith("{process:?:")) {
                orgunitIDs = documentContext.getItemValue("process.ref");
                for (String id : orgunitIDs) {
                    textList.add(role.replace(":?:", ":" + id + ":"));
                }
            }
            event.setTextList(textList);
        } else {
            event.setText(role);
        }
    }
}

