/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.team;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.marty.util.WorkitemHelper;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class TeamService {
    int DEFAULT_CACHE_SIZE = 30;
    final int MAX_SEARCH_COUNT = 1;
    private static Logger logger = Logger.getLogger(TeamService.class.getName());
    @EJB
    private DocumentService documentService;
    @Resource
    private SessionContext ctx;

    @PostConstruct
    void init() {
    }

    public List<ItemCollection> getProcessList() {
        ArrayList<ItemCollection> processList = new ArrayList<ItemCollection>();
        List col = this.documentService.getDocumentsByType("process");
        for (ItemCollection process : col) {
            ItemCollection clone = this.cloneOrgItemCollection(process);
            processList.add(clone);
        }
        Collections.sort(processList, new ItemCollectionComparator("name", true));
        return processList;
    }

    public List<ItemCollection> getSpaces() {
        ArrayList<ItemCollection> spaces = new ArrayList<ItemCollection>();
        List col = this.documentService.getDocumentsByType("space");
        for (ItemCollection space : col) {
            ItemCollection clone = this.cloneOrgItemCollection(space);
            spaces.add(clone);
        }
        Collections.sort(spaces, new ItemCollectionComparator("name", true));
        return spaces;
    }

    public ItemCollection getSpaceByName(String name) {
        List spaces;
        String query = "type:\"space\" AND (txtname:\"" + name + "\" OR name:\"" + name + "\")";
        try {
            spaces = this.documentService.find(query, 1, 0);
        }
        catch (QueryException e) {
            logger.warning("Failed to lookup space name '" + name + "'!");
            return null;
        }
        if (spaces.size() >= 1) {
            return (ItemCollection)spaces.get(0);
        }
        return null;
    }

    public ItemCollection getProcessByName(String name) {
        List spaces;
        String query = "type:\"process\" AND (txtname:\"" + name + "\" OR name:\"" + name + "\")";
        try {
            spaces = this.documentService.find(query, 1, 0);
        }
        catch (QueryException e) {
            logger.warning("Failed to lookup space name '" + name + "'!");
            return null;
        }
        if (spaces.size() >= 1) {
            return (ItemCollection)spaces.get(0);
        }
        return null;
    }

    private ItemCollection cloneOrgItemCollection(ItemCollection orgunit) {
        ItemCollection clone = WorkitemHelper.clone(orgunit);
        String type = "";
        if (orgunit.getType().startsWith("space")) {
            type = "space";
        }
        if (orgunit.getType().startsWith("process")) {
            type = "process";
        }
        clone.replaceItemValue("isTeam", (Object)false);
        clone.replaceItemValue("isManager", (Object)false);
        clone.replaceItemValue("isAssist", (Object)false);
        List vNameList = orgunit.getItemValue(type + ".team");
        if (this.documentService.isUserContained(vNameList)) {
            clone.replaceItemValue("isTeam", (Object)true);
        }
        if (this.documentService.isUserContained(vNameList = orgunit.getItemValue(type + ".manager"))) {
            clone.replaceItemValue("isManager", (Object)true);
        }
        if (this.documentService.isUserContained(vNameList = orgunit.getItemValue(type + ".assist"))) {
            clone.replaceItemValue("isAssist", (Object)true);
        }
        boolean bMember = false;
        if (clone.getItemValueBoolean("isTeam") || clone.getItemValueBoolean("isManager") || clone.getItemValueBoolean("isAssist")) {
            bMember = true;
        }
        clone.replaceItemValue("isMember", (Object)bMember);
        clone.replaceItemValue("txtWorkflowList", (Object)orgunit.getItemValue("txtWorkflowList"));
        clone.replaceItemValue("txtReportList", (Object)orgunit.getItemValue("txtReportList"));
        clone.replaceItemValue("txtdescription", (Object)orgunit.getItemValue("txtdescription"));
        return clone;
    }
}

