/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.util;

import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.imixs.workflow.ItemCollection;

@Stateless
@LocalBean
public class ImageCompactor {
    private static Logger logger = Logger.getLogger(ImageCompactor.class.getName());
    String fileExtentions = "jpg,JPEG";

    public void resize(ItemCollection workitem, int maxSize) throws Exception {
        logger.finest("Image Interceptor started");
        List filenames = workitem.getFileNames();
        for (String fileName : filenames) {
            BufferedImage originalImage;
            if (!this.isPhoto(fileName) || (originalImage = this.getImageFromWorkitem(workitem, fileName)) == null || originalImage.getWidth() <= maxSize) continue;
            logger.info("...rezise new photo: " + fileName);
            int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
            BufferedImage resizeImageHintJpg = this.resizeImageWithHint(originalImage, type, maxSize);
            if (resizeImageHintJpg == null) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resizeImageHintJpg, this.getFormatName(fileName), baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            this.replaceImage(workitem, fileName, imageInByte);
        }
    }

    private boolean isPhoto(String aname) {
        if (aname == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(this.fileExtentions, ",");
        while (st.hasMoreElements()) {
            String sExtention = st.nextToken().toLowerCase();
            if (!aname.toLowerCase().endsWith(sExtention)) continue;
            return true;
        }
        return false;
    }

    private BufferedImage resizeImageWithHint(BufferedImage originalImage, int type, int imageMaxWidth) {
        float width = originalImage.getWidth();
        float height = originalImage.getHeight();
        float factor = width / (float)imageMaxWidth;
        int newHeight = (int)(height / factor);
        BufferedImage resizedImage = new BufferedImage(imageMaxWidth, newHeight, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, imageMaxWidth, newHeight, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return resizedImage;
    }

    private BufferedImage getImageFromWorkitem(ItemCollection workItem, String file) {
        Map mapFiles = null;
        List vFiles = workItem.getItemValue("$file");
        if (vFiles != null && vFiles.size() > 0) {
            mapFiles = (Map)vFiles.get(0);
            List fileInfoList = new Vector();
            fileInfoList = (List)mapFiles.get(file);
            if (fileInfoList != null) {
                String sContentType = fileInfoList.get(0).toString();
                byte[] fileContent = (byte[])fileInfoList.get(1);
                if (fileContent != null && fileContent.length > 2) {
                    try {
                        Iterator<ImageReader> inReaders = ImageIO.getImageReadersByFormatName(this.getFormatName(file));
                        ImageReader imageReader = inReaders.next();
                        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(fileContent));
                        imageReader.setInput(iis);
                        BufferedImage originalImage = imageReader.read(0);
                        return originalImage;
                    }
                    catch (IOException e) {
                        logger.severe("ImageInerceptor - unable to load image from workitem : " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private String getFormatName(String aFilename) {
        if (aFilename.indexOf(46) == -1) {
            return null;
        }
        String inFormat = aFilename.substring(aFilename.lastIndexOf(46) + 1);
        return inFormat.toLowerCase();
    }

    private void replaceImage(ItemCollection workItem, String file, byte[] content) {
        if (content == null) {
            return;
        }
        Map mapFiles = null;
        List vFiles = workItem.getItemValue("$file");
        if (vFiles != null && vFiles.size() > 0) {
            mapFiles = (Map)vFiles.get(0);
            List<byte[]> fileInfoList = new Vector();
            fileInfoList = (List)mapFiles.get(file);
            if (fileInfoList != null) {
                fileInfoList.set(1, content);
                mapFiles.put(file, fileInfoList);
            }
        }
        Vector<Map> vNew = new Vector<Map>();
        vNew.add(mapFiles);
        workItem.replaceItemValue("$file", vNew);
    }
}

