/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;

public abstract class AbstractClient {
    private static final Logger logger = Logger.getLogger(AbstractClient.class.getName());
    protected String baseURI = null;
    protected List<ClientRequestFilter> requestFilterList = new ArrayList<ClientRequestFilter>();

    public AbstractClient(String base_uri) {
        if (!base_uri.endsWith("/")) {
            base_uri = base_uri + "/";
        }
        this.baseURI = base_uri;
        logger.finest("......register jax-rs client for " + base_uri + "...");
    }

    public void registerClientRequestFilter(ClientRequestFilter filter) {
        logger.finest("......register new request filter: " + filter.getClass().getSimpleName());
        this.requestFilterList.add(filter);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public Client newClient() {
        Client client = ClientBuilder.newClient();
        for (ClientRequestFilter filter : this.requestFilterList) {
            client.register((Object)filter);
        }
        return client;
    }
}

