/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import org.imixs.melman.AbstractClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;

public class EventLogClient
extends AbstractClient {
    public static final String ITEM_ERROR_CODE = "$error_code";
    public static final String ITEM_ERROR_MESSAGE = "$error_message";
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static final Logger logger = Logger.getLogger(EventLogClient.class.getName());
    protected int pageSize = 10;
    protected int pageIndex;

    public EventLogClient(String base_uri) {
        super(base_uri);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void deleteEventLogEntry(String eventLogID) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/" + eventLogID;
            client.target(uri).request(new String[]{"application/xml"}).delete();
        }
    }

    public List<ItemCollection> searchEventLog(String ... topic) throws RestAPIException {
        List<ItemCollection> eventLogEntries = null;
        String topicList = "";
        for (String _topic : topic) {
            topicList = topicList + _topic + "~";
        }
        if (topicList.endsWith("~")) {
            topicList = topicList.substring(0, topicList.length() - 1);
        }
        eventLogEntries = this.getCustomResource("/eventlog/" + topicList);
        logger.finest("......" + eventLogEntries.size() + " event log entries found");
        return eventLogEntries;
    }

    private XMLDataCollection getCustomResourceXML(String uri) throws RestAPIException {
        Client client = null;
        XMLDataCollection data = null;
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!uri.matches("\\w+\\:.*")) {
            uri = this.getBaseURI() + uri;
        }
        try {
            client = this.newClient();
            data = (XMLDataCollection)client.target(uri).request(new String[]{"application/xml"}).get(XMLDataCollection.class);
            if (data != null) {
                XMLDataCollection xMLDataCollection = data;
                return xMLDataCollection;
            }
        }
        catch (ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(EventLogClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error requesting custom XMLDataCollection ->" + message, (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return null;
    }

    private List<ItemCollection> getCustomResource(String uri) throws RestAPIException {
        XMLDataCollection data = null;
        data = this.getCustomResourceXML(uri);
        if (data == null) {
            return null;
        }
        return XMLDataCollectionAdapter.putDataCollection((XMLDataCollection)data);
    }
}

