/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ResponseProcessingException;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

public class WorkflowClient
extends DocumentClient {
    private static final Logger logger = Logger.getLogger(WorkflowClient.class.getName());

    public WorkflowClient(String base_uri) {
        super(base_uri);
    }

    public ItemCollection processWorkitem(ItemCollection workitem) throws RestAPIException {
        logger.finest("......process workitem...");
        XMLDocument xmlWorkitem = XMLDocumentAdapter.getDocument((ItemCollection)workitem);
        XMLDataCollection data = this.postXMLDocument(this.baseURI + "workflow/workitem/", xmlWorkitem);
        if (data != null && data.getDocument().length > 0) {
            return XMLDocumentAdapter.putDocument((XMLDocument)data.getDocument()[0]);
        }
        return null;
    }

    public ItemCollection getWorkitem(String uniqueid) throws RestAPIException {
        return this.getDocument(uniqueid);
    }

    public void deleteWorkitem(String uniqueid) throws RestAPIException {
        super.deleteDocument(uniqueid);
    }

    public List<ItemCollection> getTaskListByCreator(String userid) throws RestAPIException {
        return this.getWorkitemsByResource("/tasklist/creator/" + userid);
    }

    public List<ItemCollection> getTaskListByOwner(String userid) throws RestAPIException {
        return this.getWorkitemsByResource("/tasklist/owner/" + userid);
    }

    public List<ItemCollection> getWorkflowEventsByWorkitem(ItemCollection workitem) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            XMLDataCollection data = (XMLDataCollection)client.target(this.baseURI + "workflow/workitem/events/" + workitem.getUniqueID()).request(new String[]{"application/xml"}).get(XMLDataCollection.class);
            if (data != null) {
                List list = XMLDataCollectionAdapter.putDataCollection((XMLDataCollection)data);
                return list;
            }
        }
        return null;
    }

    private List<ItemCollection> getWorkitemsByResource(String resource) throws RestAPIException {
        Client client = null;
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        String uri = this.baseURI + "workflow" + resource;
        uri = uri + "?type=" + this.getType();
        if (this.pageSize > 0 || this.pageIndex > 0) {
            uri = uri + "&pageSize=" + this.pageSize + "&pageIndex=" + this.pageIndex;
        }
        if (this.getSortBy() != null) {
            uri = uri + "&sortBy=" + this.getSortBy();
        }
        if (this.isSortReverse()) {
            uri = uri + "&sortReverse=" + this.isSortReverse();
        }
        if (this.items != null && !this.items.isEmpty()) {
            uri = uri + "&items=" + this.items;
        }
        try {
            client = this.newClient();
            XMLDataCollection data = (XMLDataCollection)client.target(uri).request(new String[]{"application/xml"}).get(XMLDataCollection.class);
            if (data != null) {
                List list = XMLDataCollectionAdapter.putDataCollection((XMLDataCollection)data);
                return list;
            }
        }
        catch (ResponseProcessingException e) {
            throw new RestAPIException(WorkflowClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error requesting " + resource, (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return null;
    }
}

