/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.imixs.melman.AbstractClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLCount;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

public class DocumentClient
extends AbstractClient {
    public static final String ITEM_ERROR_CODE = "$error_code";
    public static final String ITEM_ERROR_MESSAGE = "$error_message";
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final String DEFAULT_TYPE = "workitem";
    private static final Logger logger = Logger.getLogger(DocumentClient.class.getName());
    protected String sortBy;
    protected boolean sortReverse;
    protected String type = "workitem";
    protected int pageSize = 10;
    protected int pageIndex;
    protected String items = null;

    public DocumentClient(String base_uri) {
        super(base_uri);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isSortReverse() {
        return this.sortReverse;
    }

    public void setSortReverse(boolean sortReverse) {
        this.sortReverse = sortReverse;
    }

    public void setSortOrder(String sortBy, boolean sortReverse) {
        this.setSortBy(sortBy);
        this.setSortReverse(sortReverse);
    }

    public ItemCollection saveDocument(ItemCollection document) throws RestAPIException {
        XMLDocument xmlWorkitem = XMLDocumentAdapter.getDocument((ItemCollection)document);
        XMLDataCollection data = this.postXMLDocument(this.baseURI + "documents/", xmlWorkitem);
        if (data != null && data.getDocument().length > 0) {
            return XMLDocumentAdapter.putDocument((XMLDocument)data.getDocument()[0]);
        }
        return null;
    }

    public ItemCollection createAdminPJob(ItemCollection document) throws RestAPIException {
        XMLDocument xmlWorkitem = XMLDocumentAdapter.getDocument((ItemCollection)document);
        XMLDataCollection data = this.postXMLDocument(this.baseURI + "adminp/jobs/", xmlWorkitem);
        if (data != null && data.getDocument().length > 0) {
            return XMLDocumentAdapter.putDocument((XMLDocument)data.getDocument()[0]);
        }
        return null;
    }

    public ItemCollection getDocument(String uniqueid) throws RestAPIException {
        Client client = null;
        String uri = this.baseURI + "documents/" + uniqueid;
        if (this.items != null && !this.items.isEmpty()) {
            uri = uri + "?items=" + this.items;
        }
        try {
            client = this.newClient();
            XMLDataCollection data = (XMLDataCollection)client.target(uri).request(new String[]{"application/xml"}).get(XMLDataCollection.class);
            if (data != null) {
                if (data.getDocument().length == 0) {
                    ItemCollection itemCollection = null;
                    return itemCollection;
                }
                XMLDocument xmldoc = data.getDocument()[0];
                ItemCollection itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)xmldoc);
                return itemCollection;
            }
        }
        catch (ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error request XMLDataCollection ->" + message, (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return null;
    }

    public void deleteDocument(String uniqueid) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "documents/" + uniqueid;
            client.target(uri).request(new String[]{"application/xml"}).delete();
        }
    }

    public List<ItemCollection> searchDocuments(String query) throws RestAPIException, UnsupportedEncodingException {
        String uri = "documents/search/";
        query = URLEncoder.encode(query, "UTF-8");
        uri = uri + query;
        List<ItemCollection> searchResult = this.getCustomResource(uri);
        return searchResult;
    }

    public long countDocuments(String query) throws RestAPIException, UnsupportedEncodingException {
        String uri = "documents/count/";
        query = URLEncoder.encode(query, "UTF-8");
        uri = uri + query;
        Client client = null;
        XMLCount xmlcount = null;
        uri = this.getBaseURI() + uri;
        try {
            client = this.newClient();
            xmlcount = (XMLCount)client.target(uri).request(new String[]{"application/xml"}).get(XMLCount.class);
            if (xmlcount != null) {
                long l = xmlcount.count;
                return l;
            }
        }
        catch (ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error countDocuments ->" + message, (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return 0L;
    }

    public List<ItemCollection> getCustomResource(String uri) throws RestAPIException {
        XMLDataCollection data = null;
        data = this.getCustomResourceXML(uri);
        if (data == null) {
            return null;
        }
        return XMLDataCollectionAdapter.putDataCollection((XMLDataCollection)data);
    }

    public WebTarget getWebTarget(String uri) throws RestAPIException {
        Client client = null;
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!uri.matches("\\w+\\:.*")) {
            uri = this.getBaseURI() + uri;
        }
        client = this.newClient();
        return client.target(uri);
    }

    public XMLDataCollection getCustomResourceXML(String uri) throws RestAPIException {
        Client client = null;
        XMLDataCollection data = null;
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!uri.matches("\\w+\\:.*")) {
            uri = this.getBaseURI() + uri;
        }
        try {
            client = this.newClient();
            data = (XMLDataCollection)client.target(uri).request(new String[]{"application/xml"}).get(XMLDataCollection.class);
            if (data != null) {
                XMLDataCollection xMLDataCollection = data;
                return xMLDataCollection;
            }
        }
        catch (ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error requesting custom XMLDataCollection ->" + message, (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return null;
    }

    public XMLDataCollection postXMLDocument(String uri, XMLDocument xmlWorkitem) throws RestAPIException {
        block13: {
            Client client = null;
            if (uri.startsWith("/")) {
                uri = uri.substring(1);
            }
            if (!uri.matches("\\w+\\:.*")) {
                uri = this.getBaseURI() + uri;
            }
            if (this.items != null && !this.items.isEmpty()) {
                uri = uri.contains("?") ? uri + "&" : uri + "?";
                uri = uri + "items=" + this.items;
            }
            try {
                client = this.newClient();
                Response response = client.target(uri).request(new String[]{"application/xml"}).post(Entity.entity((Object)xmlWorkitem, (String)"application/xml"));
                if (response.getStatus() < 300) {
                    XMLDataCollection data;
                    if (response.hasEntity() && (data = (XMLDataCollection)response.readEntity(XMLDataCollection.class)) != null && data.getDocument().length > 0) {
                        ItemCollection result = XMLDocumentAdapter.putDocument((XMLDocument)data.getDocument()[0]);
                        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                            XMLDataCollection xMLDataCollection = data;
                            return xMLDataCollection;
                        }
                        throw new RestAPIException(DocumentClient.class.getSimpleName(), result.getItemValueString(ITEM_ERROR_CODE), result.getItemValueString(ITEM_ERROR_MESSAGE));
                    }
                    break block13;
                }
                throw new RestAPIException(DocumentClient.class.getSimpleName(), "" + response.getStatus(), response.getStatus() + ": " + response.getStatusInfo().getReasonPhrase());
            }
            catch (ProcessingException e) {
                String message = null;
                message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error post XMLDocument ->" + message, (Exception)((Object)e));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        return null;
    }

    public void postXMLDataCollection(String uri, XMLDataCollection xmlDataCollection) throws RestAPIException {
        Client client = null;
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!uri.matches("\\w+\\:.*")) {
            uri = this.getBaseURI() + uri;
        }
        try {
            client = this.newClient();
            Response response = client.target(uri).request(new String[]{"application/xml"}).post(Entity.entity((Object)xmlDataCollection, (String)"application/xml"));
            if (response.getStatus() >= 300) {
                throw new RestAPIException(DocumentClient.class.getSimpleName(), "" + response.getStatus(), "" + response.getStatusInfo());
            }
        }
        catch (ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error post XMLDataCollection ->" + message, (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

