/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import org.imixs.melman.AbstractClient;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;

public class EventLogClient
extends AbstractClient {
    public static final String ITEM_ERROR_CODE = "$error_code";
    public static final String ITEM_ERROR_MESSAGE = "$error_message";
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static final Logger logger = Logger.getLogger(EventLogClient.class.getName());
    protected int pageSize = 10;
    protected int pageIndex;

    public EventLogClient(String base_uri) {
        super(base_uri);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void deleteEventLogEntry(String eventLogID) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/" + eventLogID;
            client.target(uri).request(new String[]{"application/xml"}).delete();
        }
    }

    public void lockEventLogEntry(String eventLogID) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/lock/" + eventLogID;
            client.target(uri).request(new String[]{"application/xml"}).post(null);
        }
    }

    public void unlockEventLogEntry(String eventLogID) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/unlock/" + eventLogID;
            client.target(uri).request(new String[]{"application/xml"}).post(null);
        }
    }

    public void releaseDeadLocks(long deadLockInterval, String ... topic) throws RestAPIException {
        Client client = null;
        String _topicList = "";
        for (String aTopic : topic) {
            _topicList = _topicList + aTopic + "~";
        }
        try {
            client = this.newClient();
            String uri = this.baseURI + "eventlog/release/" + deadLockInterval + "/" + _topicList;
            client.target(uri).request(new String[]{"application/xml"}).post(null);
        }
        catch (NotFoundException | ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error releaseDeadLocks ->" + message, (Exception)e);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    public List<ItemCollection> searchEventLog(String ... topic) throws RestAPIException {
        List<ItemCollection> eventLogEntries = null;
        String topicList = "";
        for (String _topic : topic) {
            topicList = topicList + _topic + "~";
        }
        if (topicList.endsWith("~")) {
            topicList = topicList.substring(0, topicList.length() - 1);
        }
        eventLogEntries = this.getCustomResource("/eventlog/" + topicList);
        logger.finest("......" + eventLogEntries.size() + " event log entries found");
        return eventLogEntries;
    }
}

