/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Cookie;

public class FormAuthenticator
implements ClientRequestFilter {
    private String baseUri;
    private String domain;
    private String path;
    private String jsessionID;
    private final String USER_AGENT = "Mozilla/5.0";
    private static final Logger logger = Logger.getLogger(FormAuthenticator.class.getName());

    public FormAuthenticator(String _baseUri, String _jsessionid) {
        block2: {
            this.baseUri = null;
            this.domain = null;
            this.path = null;
            this.jsessionID = null;
            this.USER_AGENT = "Mozilla/5.0";
            boolean debug = logger.isLoggable(Level.FINE);
            this.jsessionID = _jsessionid;
            this.baseUri = _baseUri;
            try {
                URL baseUrl = new URL(this.baseUri);
                this.domain = baseUrl.getHost();
                this.path = baseUrl.getPath();
            }
            catch (MalformedURLException e) {
                logger.warning("unable to connect: " + e.getMessage());
                if (!debug) break block2;
                e.printStackTrace();
            }
        }
    }

    public FormAuthenticator(String _baseUri, String username, String password) {
        block7: {
            this.baseUri = null;
            this.domain = null;
            this.path = null;
            this.jsessionID = null;
            this.USER_AGENT = "Mozilla/5.0";
            boolean debug = logger.isLoggable(Level.FINE);
            this.baseUri = _baseUri;
            if (debug) {
                logger.finest("......baseUIR= " + this.baseUri);
            }
            try {
                URL baseUrl = new URL(this.baseUri);
                this.domain = baseUrl.getHost();
                this.path = baseUrl.getPath();
                CookieManager manager = new CookieManager();
                manager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
                CookieHandler.setDefault(manager);
                URL obj = new URL(this.baseUri + "/j_security_check");
                HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                con.setRequestProperty("Connection", "close");
                con.setRequestMethod("POST");
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
                String urlParameters = "j_username=" + username + "&j_password=" + password;
                con.setDoOutput(true);
                con.setDoInput(true);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.writeBytes(urlParameters);
                wr.flush();
                wr.close();
                int responseCode = con.getResponseCode();
                if (debug) {
                    logger.fine(".....Response Code : " + responseCode);
                }
                if (responseCode >= 200 && responseCode < 300) {
                    String inputLine;
                    con.connect();
                    CookieStore cookieJar = manager.getCookieStore();
                    List<HttpCookie> cookiesListe = cookieJar.getCookies();
                    for (HttpCookie cookie : cookiesListe) {
                        if (!"JSESSIONID".equalsIgnoreCase(cookie.getName())) continue;
                        this.jsessionID = cookie.getValue();
                        if (!debug) break;
                        logger.finest("......jsessionID retrieved: " + this.jsessionID);
                        break;
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuffer response = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                logger.warning("unable to connect: " + e.getMessage());
                if (!debug) break block7;
                e.printStackTrace();
            }
        }
    }

    public String getJsessionID() {
        return this.jsessionID;
    }

    public void setJsessionID(String jsessionID) {
        this.jsessionID = jsessionID;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.jsessionID != null && !"".equals(this.jsessionID)) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            logger.finest("......create new JSESSIONID cookie");
            Cookie n = new Cookie("JSESSIONID", this.jsessionID, this.path, this.domain);
            cookies.add(n);
            requestContext.getHeaders().put((Object)"Cookie", cookies);
        }
    }
}

