/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Cookie;

public class FormAuthenticator
implements ClientRequestFilter {
    private ArrayList<Object> cookies = new ArrayList();
    private final String USER_AGENT = "Mozilla/5.0";
    private static final Logger logger = Logger.getLogger(FormAuthenticator.class.getName());

    public FormAuthenticator(String baseUri, String username, String password) {
        baseUri = baseUri + "/j_security_check";
        logger.finest("......baseUIR= " + baseUri);
        try {
            String inputLine;
            CookieManager manager = new CookieManager();
            manager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(manager);
            URL obj = new URL(baseUri);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestProperty("Connection", "close");
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            String urlParameters = "j_username=" + username + "&j_password=" + password;
            con.setDoOutput(true);
            con.setDoInput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            logger.info(".....Response Code : " + responseCode);
            con.connect();
            CookieStore cookieJar = manager.getCookieStore();
            List<HttpCookie> cookiesListe = cookieJar.getCookies();
            for (HttpCookie cookie : cookiesListe) {
                Cookie n = new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain());
                this.cookies.add(n);
                logger.finest("......CookieHandler retrieved cookie: " + cookie);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.cookies != null) {
            requestContext.getHeaders().put((Object)"Cookie", this.cookies);
        }
    }
}

