/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.WebTarget;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;

public abstract class AbstractClient {
    private static final Logger logger = Logger.getLogger(AbstractClient.class.getName());
    protected String baseURI = null;
    protected SSLContext sslContext = null;
    protected List<ClientRequestFilter> requestFilterList;

    public AbstractClient(String base_uri) {
        if (base_uri != null) {
            this.requestFilterList = new ArrayList<ClientRequestFilter>();
            if (!((String)base_uri).endsWith("/")) {
                base_uri = (String)base_uri + "/";
            }
            this.baseURI = base_uri;
            logger.finest("......register jax-rs client for " + (String)base_uri + "...");
            String useInsecure = System.getenv("IMIXS_REST_CLIENT_INSECURE");
            if (useInsecure != null && useInsecure.equalsIgnoreCase("true")) {
                try {
                    this.initNoopTrustManager();
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    logger.severe("Failed to setup noopTrustManager: " + e.getMessage());
                }
            }
        } else {
            logger.severe("Endpoint not defined!");
        }
    }

    private void initNoopTrustManager() throws KeyManagementException, NoSuchAlgorithmException {
        logger.info("...init insecure NoopTrustManager!");
        TrustManager[] noopTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        this.sslContext = SSLContext.getInstance("ssl");
        this.sslContext.init(null, noopTrustManager, null);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void registerClientRequestFilter(ClientRequestFilter filter) {
        logger.finest("......register new request filter: " + filter.getClass().getSimpleName());
        this.requestFilterList.add(filter);
    }

    public List<ClientRequestFilter> getRequestFilterList() {
        return this.requestFilterList;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public Client newClient() {
        Client client = null;
        if (this.sslContext != null) {
            logger.finest("...using custom sslContext to connect...");
            client = ClientBuilder.newBuilder().sslContext(this.sslContext).build();
        } else {
            client = ClientBuilder.newClient();
        }
        for (ClientRequestFilter filter : this.requestFilterList) {
            client.register((Object)filter);
        }
        return client;
    }

    public void logout() {
        Client client = this.newClient();
        if (client != null) {
            try {
                logger.finest("......perform logout at: " + this.getBaseURI() + "logout");
                client.target(this.getBaseURI() + "logout").request().get();
            }
            catch (NotFoundException e) {
                logger.warning("logout not possible - /logout is not defined by server endpoint!");
            }
            finally {
                client.close();
            }
        }
        this.requestFilterList = new ArrayList<ClientRequestFilter>();
    }

    public List<ItemCollection> getCustomResource(String uri) throws RestAPIException {
        XMLDataCollection data = null;
        data = this.getCustomResourceXML(uri);
        if (data == null) {
            return null;
        }
        return XMLDataCollectionAdapter.putDataCollection((XMLDataCollection)data);
    }

    public XMLDataCollection getCustomResourceXML(String uri) throws RestAPIException {
        Client client = null;
        XMLDataCollection data = null;
        if (((String)uri).startsWith("/")) {
            uri = ((String)uri).substring(1);
        }
        if (!((String)uri).matches("\\w+\\:.*")) {
            uri = this.getBaseURI() + (String)uri;
        }
        try {
            client = this.newClient();
            data = (XMLDataCollection)client.target((String)uri).request(new String[]{"application/xml"}).get(XMLDataCollection.class);
            if (data != null) {
                XMLDataCollection xMLDataCollection = data;
                return xMLDataCollection;
            }
        }
        catch (NotFoundException | ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(EventLogClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "GET " + (String)uri + " failed ->" + message, (Exception)e);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return null;
    }

    public WebTarget getWebTarget(String uri) throws RestAPIException {
        Client client = null;
        if (((String)uri).startsWith("/")) {
            uri = ((String)uri).substring(1);
        }
        if (!((String)uri).matches("\\w+\\:.*")) {
            uri = this.getBaseURI() + (String)uri;
        }
        client = this.newClient();
        return client.target((String)uri);
    }
}

