/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.melman.AbstractClient;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

public class EventLogClient
extends AbstractClient {
    public static final String ITEM_ERROR_CODE = "$error_code";
    public static final String ITEM_ERROR_MESSAGE = "$error_message";
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static final Logger logger = Logger.getLogger(EventLogClient.class.getName());
    protected int pageSize = 10;
    protected int pageIndex;

    public EventLogClient(String base_uri) {
        super(base_uri);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void deleteEventLogEntry(String eventLogID) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/" + eventLogID;
            client.target(uri).request(new String[]{"application/xml"}).delete();
        }
    }

    public void createEventLogEntry(String topic, String refID, ItemCollection document) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/" + topic + "/" + refID;
            Response response = null;
            if (document != null) {
                XMLDocument xmlWorkitem = XMLDocumentAdapter.getDocument((ItemCollection)document);
                response = client.target(uri).request(new String[]{"application/xml"}).put(Entity.entity((Object)xmlWorkitem, (String)"application/xml"));
            } else {
                XMLDocument xmlWorkitem = XMLDocumentAdapter.getDocument((ItemCollection)new ItemCollection());
                response = client.target(uri).request(new String[]{"application/xml"}).put(Entity.entity((Object)xmlWorkitem, (String)"application/xml"));
            }
            if (response == null || response.getStatus() >= 300) {
                throw new RestAPIException(EventLogClient.class.getSimpleName(), "" + response.getStatus(), response.getStatus() + ": " + response.getStatusInfo().getReasonPhrase());
            }
        }
    }

    public void lockEventLogEntry(String eventLogID) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/lock/" + eventLogID;
            Response response = client.target(uri).request(new String[]{"application/xml"}).post(null);
            if (response == null || response.getStatus() >= 300) {
                throw new RestAPIException(EventLogClient.class.getSimpleName(), "" + response.getStatus(), response.getStatus() + ": " + response.getStatusInfo().getReasonPhrase());
            }
        }
    }

    public void unlockEventLogEntry(String eventLogID) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "eventlog/unlock/" + eventLogID;
            Response response = client.target(uri).request(new String[]{"application/xml"}).post(null);
            if (response == null || response.getStatus() >= 300) {
                throw new RestAPIException(EventLogClient.class.getSimpleName(), "" + response.getStatus(), response.getStatus() + ": " + response.getStatusInfo().getReasonPhrase());
            }
        }
    }

    public void releaseDeadLocks(long deadLockInterval, String ... topic) throws RestAPIException {
        Client client = null;
        Object _topicList = "";
        for (String aTopic : topic) {
            _topicList = (String)_topicList + aTopic + "~";
        }
        try {
            client = this.newClient();
            String uri = this.baseURI + "eventlog/release/" + deadLockInterval + "/" + (String)_topicList;
            Response response = client.target(uri).request(new String[]{"application/xml"}).post(null);
            if (response == null || response.getStatus() >= 300) {
                throw new RestAPIException(EventLogClient.class.getSimpleName(), "" + response.getStatus(), response.getStatus() + ": " + response.getStatusInfo().getReasonPhrase());
            }
        }
        catch (NotFoundException | ProcessingException e) {
            String message = null;
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error releaseDeadLocks ->" + message, (Exception)e);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    public List<ItemCollection> searchEventLog(String ... topic) throws RestAPIException {
        List<ItemCollection> eventLogEntries = null;
        Object topicList = "";
        for (String _topic : topic) {
            topicList = (String)topicList + _topic + "~";
        }
        if (((String)topicList).endsWith("~")) {
            topicList = ((String)topicList).substring(0, ((String)topicList).length() - 1);
        }
        eventLogEntries = this.getCustomResource("/eventlog/" + (String)topicList);
        logger.finest("......" + eventLogEntries.size() + " event log entries found");
        return eventLogEntries;
    }
}

