/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Cookie;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.services.rest.RestAPIException;

public class FormAuthenticator
implements ClientRequestFilter {
    private String baseUri;
    private String domain;
    private String path;
    private String jsessionID;
    private final String USER_AGENT = "Mozilla/5.0";
    private static final Logger logger = Logger.getLogger(FormAuthenticator.class.getName());

    public FormAuthenticator(String _baseUri, String _jsessionid) {
        block2: {
            this.baseUri = null;
            this.domain = null;
            this.path = null;
            this.jsessionID = null;
            this.USER_AGENT = "Mozilla/5.0";
            boolean debug = logger.isLoggable(Level.FINE);
            this.jsessionID = _jsessionid;
            this.baseUri = _baseUri;
            try {
                URL baseUrl = new URL(this.baseUri);
                this.domain = baseUrl.getHost();
                this.path = baseUrl.getPath();
            }
            catch (MalformedURLException e) {
                logger.warning("unable to connect: " + e.getMessage());
                if (!debug) break block2;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormAuthenticator(String _baseUri, String username, String password) {
        this.baseUri = null;
        this.domain = null;
        this.path = null;
        this.jsessionID = null;
        this.USER_AGENT = "Mozilla/5.0";
        boolean debug = logger.isLoggable(Level.FINE);
        CookieHandler.setDefault(null);
        this.baseUri = _baseUri;
        if (debug) {
            logger.finest("......baseUIR= " + this.baseUri);
        }
        try {
            String inputLine;
            CookieManager manager = new CookieManager();
            manager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(manager);
            URL baseUrl = new URL(this.baseUri);
            this.domain = baseUrl.getHost();
            this.path = baseUrl.getPath();
            String loginURL = this.computeLoginURL(this.baseUri);
            logger.fine("....login page=" + loginURL);
            if (loginURL == null) {
                loginURL = _baseUri;
            }
            URL obj = new URL(loginURL);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestProperty("Connection", "close");
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            String urlParameters = "j_username=" + username + "&j_password=" + password;
            con.setDoOutput(true);
            con.setDoInput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            logger.fine(".....Response Code : " + responseCode);
            con.connect();
            CookieStore cookieJar = manager.getCookieStore();
            List<HttpCookie> cookiesListe = cookieJar.getCookies();
            for (HttpCookie cookie : cookiesListe) {
                if (!"JSESSIONID".equalsIgnoreCase(cookie.getName())) continue;
                this.jsessionID = cookie.getValue();
                if (!debug) break;
                logger.fine("......jsessionID retrieved from cookieStore: " + this.jsessionID);
                break;
            }
            logger.finest("...jsessionID=" + this.jsessionID);
            if (this.jsessionID == null) {
                logger.warning("No JSESSIONID returnd from login page!");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            logger.warning("unable to connect: " + e.getMessage());
            if (debug) {
                e.printStackTrace();
            }
        }
        finally {
            CookieHandler.setDefault(null);
        }
    }

    public String getJsessionID() {
        return this.jsessionID;
    }

    public void setJsessionID(String jsessionID) {
        this.jsessionID = jsessionID;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.jsessionID != null && !"".equals(this.jsessionID)) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            logger.finest("......set JSESSIONID cookie");
            Cookie n = new Cookie("JSESSIONID", this.jsessionID, this.path, this.domain);
            cookies.add(n);
            requestContext.getHeaders().put((Object)"Cookie", cookies);
        }
    }

    private String computeLoginURL(String apiURL) {
        block8: {
            logger.finest("... computeLoginURL...");
            Object modelURL = apiURL;
            if (!((String)modelURL).endsWith("/")) {
                modelURL = (String)modelURL + "/";
            }
            modelURL = (String)modelURL + "model";
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)new URL((String)modelURL).openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setAllowUserInteraction(false);
                int iLastHTTPResult = urlConnection.getResponseCode();
                if (iLastHTTPResult >= 200 && iLastHTTPResult <= 299) {
                    String loginPage = this.readResponse(urlConnection);
                    if (loginPage.contains("j_security_check")) {
                        int posEnd;
                        int posStart;
                        logger.finest("found Login page");
                        int pos1 = loginPage.indexOf("j_security_check");
                        if (pos1 > -1 && (posStart = (loginPage = loginPage.substring(0, posEnd = loginPage.indexOf("\"", pos1))).lastIndexOf("=\"")) > -1) {
                            String jSecurityCheck = loginPage.substring(posStart + 2, posEnd);
                            if (jSecurityCheck.startsWith("/")) {
                                int protokollPos = apiURL.indexOf("://");
                                String result = apiURL.substring(0, apiURL.indexOf("/", protokollPos + 3));
                                return result + jSecurityCheck;
                            }
                            if (apiURL.endsWith("/")) {
                                return apiURL + jSecurityCheck;
                            }
                            return apiURL + "/" + jSecurityCheck;
                        }
                        break block8;
                    }
                    logger.warning("no login page found!  ");
                    return apiURL;
                }
                String error = "Error " + iLastHTTPResult + " - failed GET request from '" + (String)modelURL + "'";
                logger.warning(error);
                throw new RestAPIException(iLastHTTPResult, error);
            }
            catch (IOException | RestAPIException e1) {
                logger.severe("failed to compute login page: " + e1.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(URLConnection urlConnection) throws IOException {
        logger.finest("......readResponse....");
        StringWriter writer = new StringWriter();
        try (BufferedReader in = null;){
            String inputLine;
            String sContentEncoding = urlConnection.getContentEncoding();
            if (sContentEncoding == null || sContentEncoding.isEmpty()) {
                sContentEncoding = "UTF-8";
            }
            in = sContentEncoding != null && !sContentEncoding.isEmpty() ? new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), sContentEncoding)) : new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                logger.finest("......" + inputLine);
                writer.write(inputLine);
            }
        }
        return writer.toString();
    }
}

