/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;

public class JWTAuthenticator
implements ClientRequestFilter {
    private final String jwt;
    private static final Logger logger = Logger.getLogger(JWTAuthenticator.class.getName());

    public JWTAuthenticator(String jwt) {
        if (jwt != null && jwt.contains("jwt=")) {
            logger.warning("Wrong JWT format! JWT may not contain 'jwt=....'");
        }
        this.jwt = jwt;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        URI uri = requestContext.getUri();
        String url = uri.toString();
        if (!url.contains("jwt=")) {
            logger.finest(".....adding JSON Web Token...");
            requestContext.getHeaders().add((Object)"jwt", (Object)this.jwt);
        }
    }
}

