/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.melman;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.util.logging.Logger;
import org.imixs.melman.AbstractClient;
import org.imixs.melman.BPMNWriter;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.bpmn.BPMNModel;

public class ModelClient
extends AbstractClient {
    private static final Logger logger = Logger.getLogger(ModelClient.class.getName());

    public ModelClient(String base_uri) {
        super(base_uri);
    }

    public void postModel(BPMNModel model) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            client.register((Object)new BPMNWriter());
            Response response = client.target(this.baseURI + "model/bpmn/").request(new String[]{"application/xml"}).post(Entity.entity((Object)model, (String)"application/xml"));
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RestAPIException(DocumentClient.class.getSimpleName(), "RESPONSE_PROCESSING_EXCEPTION", "error post BPMNModel ->" + response.getStatusInfo().getReasonPhrase());
            }
        }
    }

    public void deleteModel(String version) throws RestAPIException {
        try (Client client = null;){
            client = this.newClient();
            String uri = this.baseURI + "model/" + version;
            client.target(uri).request(new String[]{"application/xml"}).delete();
        }
    }
}

