/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.micro.socket;

import jakarta.inject.Inject;
import jakarta.websocket.DeploymentException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.micro.socket.WebSocketClient;

public class WebSocketAdapter
implements SignalAdapter {
    public static final String MODE_CREATE = "CREATE";
    public static final String ERROR_CONFIG = "CONFIG-ERROR";
    public static final String ERROR_API = "API-ERROR";
    private static final Logger logger = Logger.getLogger(WebSocketAdapter.class.getName());
    @Inject
    private WorkflowService workflowService;

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        List createDefinitions = this.workflowService.evalWorkflowResultXML(event, "imixs-micro", MODE_CREATE, workitem, false);
        if (createDefinitions != null && createDefinitions.size() > 0) {
            for (ItemCollection createDefinition : createDefinitions) {
                String endpoint = createDefinition.getItemValueString("endpoint");
                String model = createDefinition.getItemValueString("model");
                int taskID = createDefinition.getItemValueInteger("task");
                int eventID = createDefinition.getItemValueInteger("event");
                String items = createDefinition.getItemValueString("items");
                boolean debug = createDefinition.getItemValueBoolean("debug");
                if (debug) {
                    logger.info("connecting: " + endpoint + "...");
                }
                WebSocketClient client = null;
                try {
                    String[] itemList;
                    client = new WebSocketClient(endpoint);
                    ItemCollection workitemToSend = new ItemCollection();
                    workitemToSend.model(model).task(taskID).event(eventID);
                    for (String itemName : itemList = items.split(";")) {
                        workitemToSend.setItemValue(itemName, (Object)workitem.getItemValue(itemName));
                    }
                    if (debug) {
                        logger.info("sending request...");
                    }
                    client.sendItemCollection(workitemToSend);
                }
                catch (DeploymentException | IOException e) {
                    throw new PluginException(WebSocketAdapter.class.getSimpleName(), "ERROR_CONFIG", "Failed to connect to endpoint '" + endpoint + "' : " + e.getMessage(), (Exception)e);
                }
                finally {
                    if (client != null) {
                        if (debug) {
                            logger.info("closing connection...");
                        }
                        client.close();
                    }
                }
            }
        }
        return workitem;
    }
}

