/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.micro.socket;

import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.micro.socket.WebSocketAdapter;

@ClientEndpoint
public class WebSocketClient {
    private static final Logger logger = Logger.getLogger(WebSocketClient.class.getName());
    private LinkedBlockingDeque<ItemCollection> MESSAGES = null;
    private Session session = null;
    private String endpoint = null;

    public WebSocketClient(String endpoint) throws DeploymentException, IOException {
        this.endpoint = endpoint;
        this.MESSAGES = new LinkedBlockingDeque();
        this.session = ContainerProvider.getWebSocketContainer().connectToServer((Object)this, URI.create(endpoint));
    }

    public Session getSession() {
        return this.session;
    }

    @OnMessage
    public void onMessage(ByteBuffer bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes.array());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Map data = (Map)ois.readObject();
            ItemCollection workitem = new ItemCollection(data);
            this.MESSAGES.add(workitem);
        }
        catch (IOException | ClassNotFoundException e) {
            logger.severe("Error receiving ItemCollection: " + e.getMessage());
        }
    }

    public ItemCollection receiveWorkitem() throws Exception {
        return this.MESSAGES.poll(10L, TimeUnit.SECONDS);
    }

    public void sendItemCollection(ItemCollection item) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(item.getAllItems());
        oos.close();
        this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(baos.toByteArray()));
    }

    public void close() throws PluginException {
        if (this.session != null && this.session.isOpen()) {
            try {
                this.session.close();
            }
            catch (IOException e) {
                throw new PluginException(WebSocketAdapter.class.getSimpleName(), "ERROR_API", "Failed to close webSocket connection to endpoint '" + this.endpoint + "' : " + e.getMessage(), (Exception)e);
            }
        }
    }
}

