/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.micro;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.imixs.workflow.ItemCollection;

public class MemoryDB {
    protected Map<String, ItemCollection> database = null;
    public static final String ISAUTHOR = "$isAuthor";
    public static final String NOINDEX = "$noindex";
    public static final String IMMUTABLE = "$immutable";

    public MemoryDB() {
        this.init();
    }

    protected void init() {
        this.database = new ConcurrentHashMap<String, ItemCollection>();
    }

    public ItemCollection load(String id) {
        ItemCollection result = this.database.get(id);
        if (result != null) {
            result.replaceItemValue(ISAUTHOR, (Object)true);
        }
        return result;
    }

    public ItemCollection save(ItemCollection data) {
        if (data != null) {
            this.database.put(data.getUniqueID(), data);
        }
        return data;
    }

    public void delete(ItemCollection data) {
        if (data != null) {
            this.database.remove(data.getUniqueID());
        }
    }
}

