/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.micro;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.imixs.workflow.Adapter;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.WorkflowManager;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.micro.MemoryDB;
import org.imixs.workflow.micro.MicroSession;
import org.openbpmn.bpmn.BPMNModel;
import org.openbpmn.bpmn.exceptions.BPMNModelException;
import org.openbpmn.bpmn.util.BPMNModelFactory;

@ApplicationScoped
public class MicroWorkflowService
implements WorkflowManager,
WorkflowContext {
    private static final Logger logger = Logger.getLogger(MicroWorkflowService.class.getName());
    public static final String UNIQUEIDREF = "$uniqueidref";
    public static final String READACCESS = "$readaccess";
    public static final String WRITEACCESS = "$writeaccess";
    public static final String PARTICIPANTS = "$participants";
    public static final String DEFAULT_TYPE = "workitem";
    public static final String INVALID_ITEMVALUE_FORMAT = "INVALID_ITEMVALUE_FORMAT";
    public static final String INVALID_TAG_FORMAT = "INVALID_TAG_FORMAT";
    private MemoryDB database = null;
    private ModelManager openBPMNModelManager;
    private MicroSession session = null;
    @Inject
    @Any
    private Instance<Plugin> plugins;
    @Inject
    @Any
    protected Instance<Adapter> adapters;

    @PostConstruct
    public void init() {
        logger.info("Initialize Workflow Service.....");
        this.database = new MemoryDB();
        this.openBPMNModelManager = new ModelManager();
        this.session = new MicroSession("sample");
    }

    public void setDevice(String device) {
        this.session.setDevice(device);
    }

    public ModelManager getModelManager() {
        return this.openBPMNModelManager;
    }

    public Object getSessionContext() {
        return this.session;
    }

    public MemoryDB getDatabase() {
        return this.database;
    }

    public void loadBPMNModel(String modelPath) {
        try {
            BPMNModel model = BPMNModelFactory.read((String)modelPath);
            this.getModelManager().addModel(model);
        }
        catch (ModelException | BPMNModelException e) {
            e.printStackTrace();
        }
    }

    public void loadBPMNModel(InputStream inputStream) {
        try {
            BPMNModel model = BPMNModelFactory.read((InputStream)inputStream);
            this.getModelManager().addModel(model);
        }
        catch (ModelException | BPMNModelException e) {
            e.printStackTrace();
        }
    }

    public void removeWorkItem(ItemCollection workitem) throws AccessDeniedException {
        this.getDatabase().delete(workitem);
    }

    public ItemCollection getWorkItem(String id) {
        return this.getDatabase().load(id);
    }

    public ItemCollection processWorkItem(ItemCollection workitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        boolean debug = logger.isLoggable(Level.FINE);
        long lStartTime = System.currentTimeMillis();
        if (workitem == null) {
            throw new ProcessingErrorException(MicroWorkflowService.class.getSimpleName(), "INVALID_WORKITEM", "workitem Is Null!");
        }
        if (!workitem.getUniqueID().isEmpty()) {
            ItemCollection currentInstance = this.getWorkItem(workitem.getUniqueID());
            if (currentInstance != null) {
                if (!currentInstance.getItemValueBoolean("$isAuthor")) {
                    throw new AccessDeniedException("OPERATION_NOTALLOWED", "$uniqueid: " + workitem.getItemValueInteger("$uniqueid") + " - No Author Access!");
                }
                if (workitem.getTaskID() > 0 && currentInstance.getTaskID() != workitem.getTaskID()) {
                    throw new ProcessingErrorException(MicroWorkflowService.class.getSimpleName(), "INVALID_PROCESSID", "$uniqueid: " + workitem.getItemValueInteger("$uniqueid") + " - $taskid=" + workitem.getTaskID() + " Did Not Match Expected $taskid=" + currentInstance.getTaskID());
                }
                workitem.mergeItems(currentInstance.getAllItems());
            } else if (workitem.getTaskID() <= 0 || workitem.getEventID() <= 0 || workitem.getModelVersion().isEmpty() && workitem.getWorkflowGroup().isEmpty()) {
                throw new InvalidAccessException("OPERATION_NOTALLOWED", "$uniqueid: " + workitem.getItemValueInteger("$uniqueid") + " - Insufficient Data or Lack Of Permission!");
            }
        }
        if ("".equals(workitem.getType())) {
            workitem.replaceItemValue("type", (Object)DEFAULT_TYPE);
        }
        BPMNModel model = null;
        try {
            model = this.getModelManager().getModel(workitem.getModelVersion());
        }
        catch (ModelException e) {
            throw new ProcessingErrorException(MicroWorkflowService.class.getSimpleName(), "INVALID_PROCESSID", e.getMessage(), (Exception)((Object)e));
        }
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        this.registerPlugins(workflowkernel, model);
        this.registerAdapters(workflowkernel);
        this.updateMetadata(workitem);
        try {
            long lKernelTime = System.currentTimeMillis();
            workitem = workflowkernel.process(workitem);
            if (debug) {
                logger.log(Level.FINE, "...WorkflowKernel processing time={0}ms", System.currentTimeMillis() - lKernelTime);
            }
        }
        catch (PluginException pe) {
            logger.log(Level.SEVERE, "processing workitem ''{0} failed, rollback transaction...", workitem.getItemValueString("$uniqueid"));
            throw pe;
        }
        List splitWorkitems = workflowkernel.getSplitWorkitems();
        for (ItemCollection splitWorkitemm : splitWorkitems) {
            this.getDatabase().save(splitWorkitemm);
        }
        workitem = this.getDatabase().save(workitem);
        if (debug) {
            logger.log(Level.FINE, "...total processing time={0}ms", System.currentTimeMillis() - lStartTime);
        }
        return workitem;
    }

    public ItemCollection evalWorkflowResult(ItemCollection event, String xmlTag, ItemCollection documentContext, boolean resolveItemValues) throws PluginException {
        boolean debug = logger.isLoggable(Level.FINE);
        ItemCollection result = new ItemCollection();
        String workflowResult = event.getItemValueString("workflow.result");
        if (workflowResult.isEmpty()) {
            workflowResult = event.getItemValueString("txtActivityResult");
        }
        if (workflowResult.trim().isEmpty()) {
            return null;
        }
        if (xmlTag == null || xmlTag.isEmpty()) {
            logger.warning("cannot eval workflow result - no tag name specified. Verify model!");
            return null;
        }
        if (workflowResult.indexOf("<" + xmlTag) == -1) {
            return null;
        }
        boolean invalidPattern = false;
        Pattern patternSimple = Pattern.compile("<" + xmlTag + " (.*?)>(.*?)|<" + xmlTag + " (.*?)./>", 32);
        Matcher matcherSimple = patternSimple.matcher(workflowResult);
        if (matcherSimple.find()) {
            invalidPattern = true;
            Pattern pattern = Pattern.compile("(?s)(?:(<" + xmlTag + "(?>\\b(?:\".*?\"|'.*?'|[^>]*?)*>)(?<=/>))|(<" + xmlTag + "(?>\\b(?:\".*?\"|'.*?'|[^>]*?)*>)(?<!/>))(.*?)(</" + xmlTag + "\\s*>))", 32);
            Matcher matcher = pattern.matcher(workflowResult);
            while (matcher.find()) {
                invalidPattern = false;
                String content = "";
                String attributes = matcher.group(1);
                if (attributes == null) {
                    attributes = matcher.group(2);
                    content = matcher.group(3);
                } else {
                    content = matcher.group(2);
                }
                if (content == null) {
                    content = "";
                }
                if (attributes != null && !attributes.isEmpty()) {
                    String spattern = "(\\S+)=[\"']?((?:.(?![\"']?\\s+(?:\\S+)=|[>\"']))+.)[\"']?";
                    Pattern attributePattern = Pattern.compile(spattern);
                    Matcher attributeMatcher = attributePattern.matcher(attributes);
                    HashMap<String, String> attrMap = new HashMap<String, String>();
                    while (attributeMatcher.find()) {
                        String attrName = attributeMatcher.group(1);
                        String attrValue = attributeMatcher.group(2);
                        attrMap.put(attrName, attrValue);
                    }
                    String tagName = (String)attrMap.get("name");
                    if (tagName == null) {
                        throw new PluginException(MicroWorkflowService.class.getSimpleName(), INVALID_TAG_FORMAT, "<" + xmlTag + "> tag contains no name attribute.");
                    }
                    for (String attrName : attrMap.keySet()) {
                        if ("name".equals(attrName)) continue;
                        result.appendItemValue(tagName + "." + attrName, attrMap.get(attrName));
                    }
                    String sType = result.getItemValueString(tagName + ".type");
                    String sFormat = result.getItemValueString(tagName + ".format");
                    if (!sType.isEmpty()) {
                        if ("boolean".equalsIgnoreCase(sType)) {
                            result.appendItemValue(tagName, (Object)Boolean.valueOf(content));
                            continue;
                        }
                        if ("integer".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Integer.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Integer(0));
                            }
                            continue;
                        }
                        if ("double".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Double.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Double(0.0));
                            }
                            continue;
                        }
                        if ("float".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Float.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Float(0.0f));
                            }
                            continue;
                        }
                        if ("long".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Long.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Long(0L));
                            }
                            continue;
                        }
                        if ("date".equalsIgnoreCase(sType)) {
                            if (content == null || content.isEmpty()) {
                                if (!debug) continue;
                                logger.finer("......can not convert empty string into date object");
                                continue;
                            }
                            try {
                                if (debug) {
                                    logger.finer("......convert string into date object");
                                }
                                Date dateResult = null;
                                if (sFormat == null || sFormat.isEmpty()) {
                                    dateResult = DateFormat.getDateTimeInstance(3, 3).parse(content);
                                } else {
                                    SimpleDateFormat dateFormat = new SimpleDateFormat(sFormat);
                                    dateResult = dateFormat.parse(content);
                                }
                                result.appendItemValue(tagName, (Object)dateResult);
                            }
                            catch (ParseException e) {
                                if (!debug) continue;
                                logger.log(Level.FINER, "failed to convert string into date object: {0}", e.getMessage());
                            }
                            continue;
                        }
                        result.appendItemValue(tagName, (Object)content);
                        continue;
                    }
                    result.appendItemValue(tagName, (Object)content);
                    continue;
                }
                throw new PluginException(MicroWorkflowService.class.getSimpleName(), INVALID_TAG_FORMAT, "<" + xmlTag + "> tag contains no name attribute.");
            }
        }
        if (invalidPattern) {
            throw new PluginException(MicroWorkflowService.class.getSimpleName(), INVALID_TAG_FORMAT, "invalid <" + xmlTag + "> tag format in workflowResult: " + workflowResult + "  , expected format is <" + xmlTag + " name=\"...\">...</item> ");
        }
        return result;
    }

    protected void registerPlugins(WorkflowKernel workflowkernel, BPMNModel model) throws PluginException, ModelException {
        boolean debug = logger.isLoggable(Level.FINE);
        ItemCollection profile = this.getModelManager().loadDefinition(model);
        List vPlugins = profile.getItemValue("txtPlugins");
        for (int i = 0; i < vPlugins.size(); ++i) {
            String aPluginClassName = (String)vPlugins.get(i);
            Plugin aPlugin = this.findPluginByName(aPluginClassName);
            if (aPlugin != null) {
                if (debug) {
                    logger.log(Level.FINEST, "......register CDI plugin class: {0}...", aPluginClassName);
                }
                workflowkernel.registerPlugin(aPlugin);
                continue;
            }
            workflowkernel.registerPlugin(aPluginClassName);
        }
    }

    protected void registerAdapters(WorkflowKernel workflowkernel) {
        boolean debug = logger.isLoggable(Level.FINE);
    }

    protected void updateMetadata(ItemCollection workitem) {
        String nameEditor = "";
        if (workitem.getItemValueString("$creator").isEmpty() && !workitem.getItemValueString("namCreator").isEmpty()) {
            workitem.replaceItemValue("$creator", (Object)workitem.getItemValue("namCreator"));
        }
        if (workitem.getItemValueString("$creator").isEmpty()) {
            workitem.replaceItemValue("$creator", (Object)nameEditor);
        }
        if (!nameEditor.equals(workitem.getItemValueString("$editor")) && !workitem.getItemValueString("$editor").isEmpty()) {
            workitem.replaceItemValue("$lasteditor", (Object)workitem.getItemValueString("$editor"));
        }
        workitem.replaceItemValue("$editor", (Object)nameEditor);
    }

    private Plugin findPluginByName(String pluginClassName) {
        if (pluginClassName == null || pluginClassName.isEmpty()) {
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        if (this.plugins == null || !this.plugins.iterator().hasNext()) {
            if (debug) {
                logger.finest("......no CDI plugins injected");
            }
            return null;
        }
        try {
            Class<?> expectedClass = Class.forName(pluginClassName);
            for (Plugin plugin : this.plugins) {
                if (!expectedClass.isAssignableFrom(plugin.getClass())) continue;
                if (debug) {
                    logger.log(Level.FINEST, "......CDI plugin ''{0}'' successfully injected", pluginClassName);
                }
                return plugin;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Could not find class for name: " + pluginClassName, e);
        }
        return null;
    }
}

