/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.micro.socket;

import io.quarkus.runtime.Startup;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.micro.MicroWorkflowService;

@Startup
@ServerEndpoint(value="/workflow")
@ApplicationScoped
public class WorkflowEngine {
    private Set<Session> sessions;
    private static final Logger logger = Logger.getLogger(WorkflowEngine.class.getName());
    @Inject
    private MicroWorkflowService workflowService;

    @PostConstruct
    void init() throws PluginException {
        logger.info("\u251c\u2500\u2500 Init Workflow-Engine...");
        this.sessions = ConcurrentHashMap.newKeySet();
        this.workflowService.setDevice("sample");
        this.loadDefaultModels();
    }

    @OnOpen
    public void onOpen(Session session) {
        logger.info("---OPEN");
        this.sessions.add(session);
    }

    @OnClose
    public void onClose(Session session) {
        this.sessions.remove(session);
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        logger.info("---ERROR : " + throwable.getMessage());
        this.sessions.remove(session);
    }

    @OnMessage
    public void onMessage(ByteBuffer bytes, Session session) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes.array());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Map data = (Map)ois.readObject();
            ItemCollection workitem = new ItemCollection(data);
            logger.info("\u251c\u2500\u2500 Received Workitem: " + workitem.getItemValueString("$uniqueid"));
            logger.info("\u2502   \u251c\u2500\u2500 ModelVersion: " + workitem.getModelVersion() + " Task: " + workitem.getTaskID());
            this.workflowService.processWorkItem(workitem);
            logger.info("\u2502   \u251c\u2500\u2500 Workitem processed: " + workitem.getItemValueString("$uniqueid"));
            logger.info("\u2514\u2500\u2500\u2500\u2534 Sending result...");
            this.sendItemCollection(session, workitem);
        }
        catch (IOException | ClassNotFoundException | AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
            logger.severe("Error receiving ItemCollection: " + e.getMessage());
        }
    }

    private void loadDefaultModels() throws PluginException {
        logger.info("\u251c\u2500\u2500 Loading default Models");
        this.loadModelsFromClasspath();
        this.loadModelsFromDirectory("/bpmn");
    }

    private void loadModelsFromClasspath() {
        try {
            File bpmnDir;
            File[] bpmnFiles;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL bpmnDirUrl = classLoader.getResource("bpmn");
            if (bpmnDirUrl != null && "file".equals(bpmnDirUrl.getProtocol()) && (bpmnFiles = (bpmnDir = new File(bpmnDirUrl.toURI())).listFiles((dir, name) -> name.toLowerCase().endsWith(".bpmn"))) != null) {
                for (File bpmnFile : bpmnFiles) {
                    String bpmnPath = "/bpmn/" + bpmnFile.getName();
                    logger.info("\u2502   \u251c\u2500\u2500 loading BPMN model: " + bpmnPath);
                    this.workflowService.loadBPMNModel(bpmnPath);
                }
            }
        }
        catch (URISyntaxException e) {
            logger.severe("Error scanning for BPMN files: " + e.getMessage());
        }
    }

    private void loadModelsFromDirectory(String path) {
        logger.info("\u2502   \u251c\u2500\u2500 scanning directory: " + path);
        File bpmnDir = new File(path);
        File[] bpmnFiles = bpmnDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".bpmn"));
        if (bpmnFiles != null) {
            for (File bpmnFile : bpmnFiles) {
                String bpmnPath = bpmnFile.getAbsolutePath();
                logger.info("\u2502   \u251c\u2500\u2500 loading BPMN model: " + bpmnPath);
                try (FileInputStream fileInputStream = new FileInputStream(bpmnFile);){
                    this.workflowService.loadBPMNModel(fileInputStream);
                }
                catch (IOException e) {
                    logger.severe("\u2502 \u2502 \u251c\u2500\u2500 error reading file: " + bpmnPath + " - " + e.getMessage());
                }
            }
        }
    }

    private void sendItemCollection(Session session, ItemCollection item) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(item.getAllItems());
            oos.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            session.getAsyncRemote().sendBinary(byteBuffer, result -> {
                if (result.isOK()) {
                    logger.info("sendBinary OK!");
                } else {
                    logger.severe("Error sending ItemCollection: " + result.getException().getMessage());
                }
            });
        }
        catch (Exception e) {
            logger.severe("Error preparing ItemCollection: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

