/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.microservice.core.auth;

import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestFilter;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.jwt.HMAC;
import org.imixs.jwt.JWTBuilder;
import org.imixs.jwt.JWTException;
import org.imixs.melman.AbstractClient;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.JWTAuthenticator;
import org.imixs.microservice.core.auth.AuthEvent;
import org.imixs.microservice.core.auth.AuthException;

@RequestScoped
public class DefaultAuthenticator {
    @Inject
    @ConfigProperty(name="imixs.auth.secret", defaultValue="")
    String authSecret;
    @Inject
    @ConfigProperty(name="imixs.auth.service", defaultValue="")
    String authService;
    @Inject
    @ConfigProperty(name="imixs.auth.userid", defaultValue="")
    String authUserID;
    @Inject
    @ConfigProperty(name="imixs.auth.method", defaultValue="CUSTOM")
    String authMethod;
    private static Logger logger = Logger.getLogger(DefaultAuthenticator.class.getName());

    public void registerRequestFilter(@Observes AuthEvent authEvent) throws AuthException {
        if ("CUSTOM".equalsIgnoreCase(this.authMethod) || this.authMethod.isEmpty()) {
            logger.finest("......Default Auth Module disabled!");
            return;
        }
        if (this.authSecret.isEmpty()) {
            logger.warning("Default Auth Module: secret not set - check your configuration!");
        }
        if (this.authUserID.isEmpty()) {
            logger.warning("Default Auth Module: secret not set - check your configuration!");
        }
        if ("JWT".equalsIgnoreCase(this.authMethod)) {
            this.registerJWTAuthenticator(authEvent.getClient());
        }
        if ("BASIC".equalsIgnoreCase(this.authMethod)) {
            this.registerBasicAuthenticator(authEvent.getClient());
        }
        if ("FORM".equalsIgnoreCase(this.authMethod)) {
            this.registerFormAuthenticator(authEvent.getClient());
        }
    }

    private void registerBasicAuthenticator(AbstractClient client) {
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(this.authUserID, this.authSecret);
        client.registerClientRequestFilter((ClientRequestFilter)basicAuthenticator);
    }

    private void registerFormAuthenticator(AbstractClient client) {
        FormAuthenticator formAuthenticator = new FormAuthenticator(this.authService, this.authUserID, this.authSecret);
        client.registerClientRequestFilter((ClientRequestFilter)formAuthenticator);
    }

    private void registerJWTAuthenticator(AbstractClient client) throws AuthException {
        SecretKey secretKey = HMAC.createKey((String)"HmacSHA256", (byte[])this.authSecret.getBytes());
        String payload = "{\"sub\":\"" + this.authUserID + "\",\"displayname\":\"" + this.authUserID + "\",\"groups\":[\"IMIXS-WORKFLOW-Manager\"]}";
        logger.finest("......Payload=" + payload);
        JWTBuilder builder = new JWTBuilder().setKey(secretKey).setPayload(payload);
        try {
            JWTAuthenticator jwtAuth = new JWTAuthenticator(builder.getToken());
            client.registerClientRequestFilter((ClientRequestFilter)jwtAuth);
        }
        catch (JWTException e) {
            e.printStackTrace();
            throw new AuthException("JWT_ERROR", e.getMessage(), (Exception)((Object)e));
        }
    }
}

