/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.microservice.security.auth;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestFilter;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.jwt.HMAC;
import org.imixs.jwt.JWTBuilder;
import org.imixs.jwt.JWTException;
import org.imixs.melman.AbstractClient;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.JWTAuthenticator;
import org.imixs.microservice.security.auth.AuthEvent;
import org.imixs.microservice.security.auth.AuthException;
import org.imixs.microservice.security.auth.PropagationAuthenticator;

@RequestScoped
public class DefaultAuthenticator {
    private static final String QUERY_PARAM_SESSION = "jwt";
    @Inject
    @ConfigProperty(name="imixs.auth.secret", defaultValue="")
    String authSecret;
    @Inject
    @ConfigProperty(name="imixs.auth.service", defaultValue="")
    String authService;
    @Inject
    @ConfigProperty(name="imixs.auth.userid", defaultValue="")
    String authUserID;
    @Inject
    @ConfigProperty(name="imixs.auth.method", defaultValue="CUSTOM")
    String authMethod;
    @Inject
    @ConfigProperty(name="imixs.auth.propagation", defaultValue="false")
    boolean propagateAuthentication;
    private static Logger logger = Logger.getLogger(DefaultAuthenticator.class.getName());

    public void registerRequestFilter(@Observes AuthEvent authEvent) throws AuthException {
        boolean debug = logger.isLoggable(Level.FINE);
        if ("CUSTOM".equalsIgnoreCase(this.authMethod) || this.authMethod.isEmpty()) {
            if (debug) {
                logger.finest("......Default Auth Module disabled!");
            }
            return;
        }
        try {
            if (this.propagateAuthentication && authEvent.getRequest() != null) {
                String authorizationToken = null;
                authorizationToken = authEvent.getRequest().getHeader("Authorization");
                if (authorizationToken == null || authorizationToken.isEmpty()) {
                    String jwt = authEvent.getRequest().getHeader(QUERY_PARAM_SESSION);
                    if (jwt != null && !jwt.isEmpty()) {
                        authorizationToken = "Bearer " + jwt;
                    } else {
                        int iPos;
                        jwt = authEvent.getRequest().getQueryString();
                        if (jwt != null && !jwt.isEmpty() && (iPos = jwt.indexOf("jwt=")) > -1) {
                            if (debug) {
                                logger.fine("parsing query param jwt....");
                            }
                            iPos = iPos + "jwt=".length() + 0;
                            if ((iPos = (jwt = jwt.substring(iPos)).indexOf("&")) > -1) {
                                jwt = jwt.substring(0, iPos);
                            }
                            jwt = this.getURLDecodedToken(jwt);
                            authorizationToken = "Bearer " + jwt;
                        }
                    }
                }
                if (authorizationToken != null && !authorizationToken.isEmpty()) {
                    this.registerPropagationAuthenticator(authEvent.getClient(), authorizationToken);
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.warning("Unable to resolve http request header - " + e.getMessage());
        }
        if (this.authSecret.isEmpty()) {
            logger.warning("Default Auth Module: secret not set - check your configuration!");
        }
        if (this.authUserID.isEmpty()) {
            logger.warning("Default Auth Module: secret not set - check your configuration!");
        }
        if ("JWT".equalsIgnoreCase(this.authMethod)) {
            this.registerJWTAuthenticator(authEvent.getClient());
        }
        if ("BASIC".equalsIgnoreCase(this.authMethod)) {
            this.registerBasicAuthenticator(authEvent.getClient());
        }
        if ("FORM".equalsIgnoreCase(this.authMethod)) {
            this.registerFormAuthenticator(authEvent.getClient());
        }
    }

    private void registerBasicAuthenticator(AbstractClient client) {
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(this.authUserID, this.authSecret);
        client.registerClientRequestFilter((ClientRequestFilter)basicAuthenticator);
    }

    private void registerFormAuthenticator(AbstractClient client) {
        FormAuthenticator formAuthenticator = new FormAuthenticator(this.authService, this.authUserID, this.authSecret);
        client.registerClientRequestFilter((ClientRequestFilter)formAuthenticator);
    }

    private void registerJWTAuthenticator(AbstractClient client) throws AuthException {
        boolean debug = logger.isLoggable(Level.FINE);
        SecretKey secretKey = HMAC.createKey((String)"HmacSHA256", (byte[])this.authSecret.getBytes());
        String payload = "{\"sub\":\"" + this.authUserID + "\",\"displayname\":\"" + this.authUserID + "\",\"groups\":[\"IMIXS-WORKFLOW-Manager\"]}";
        if (debug) {
            logger.finest("......Payload=" + payload);
        }
        JWTBuilder builder = new JWTBuilder().setKey(secretKey).setPayload(payload);
        try {
            JWTAuthenticator jwtAuth = new JWTAuthenticator(builder.getToken());
            client.registerClientRequestFilter((ClientRequestFilter)jwtAuth);
        }
        catch (JWTException e) {
            e.printStackTrace();
            throw new AuthException("JWT_ERROR", e.getMessage(), (Exception)((Object)e));
        }
    }

    private void registerPropagationAuthenticator(AbstractClient client, String token) {
        PropagationAuthenticator propagationAuthenticator = new PropagationAuthenticator(token);
        client.registerClientRequestFilter((ClientRequestFilter)propagationAuthenticator);
    }

    String getURLDecodedToken(String token) {
        try {
            token = URLDecoder.decode(token, "UTF-8");
            token = token.replaceAll(" ", "+");
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("URL decoding of token failed " + e.getMessage());
            return null;
        }
        return token;
    }
}

