/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.registry.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class RegistrySchemaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static List<String> DEFAULT_STORE_FIELD_LIST = Arrays.asList("$uniqueid", "type", "$readaccess", "$taskid", "$writeaccess", "$workflowsummary", "$workflowabstract", "$workflowgroup", "$workflowstatus", "$modified", "$created", "$modelversion", "$lasteventdate", "$creator", "$editor", "$lasteditor", "$owner", "namowner", "$api");
    private List<String> schemaFieldList = null;
    @Inject
    @ConfigProperty(name="imixs.registry.index.fields", defaultValue="")
    String imixsIndexFieldList;

    @PostConstruct
    public void init() {
        this.schemaFieldList = new ArrayList<String>();
        this.schemaFieldList.addAll(DEFAULT_STORE_FIELD_LIST);
        if (this.imixsIndexFieldList != null && !this.imixsIndexFieldList.isEmpty()) {
            StringTokenizer st = new StringTokenizer(this.imixsIndexFieldList, ",");
            while (st.hasMoreElements()) {
                String sName = st.nextToken().toLowerCase().trim();
                if (this.schemaFieldList.contains(sName)) continue;
                this.schemaFieldList.add(sName);
            }
        }
    }

    public List<String> getSchemaFieldList() {
        return this.schemaFieldList;
    }

    public String adaptQueryFieldNames(String _query) {
        String result = _query;
        if (_query == null || !_query.contains("$")) {
            return result;
        }
        for (String imixsItemName : this.schemaFieldList) {
            if (imixsItemName.charAt(0) != '$') continue;
            while (result.contains(imixsItemName + ":")) {
                String solrField = "_" + imixsItemName.substring(1);
                result = result.replace(imixsItemName + ":", solrField + ":");
            }
        }
        return result;
    }

    public String adaptSolrFieldName(String itemName) {
        String adaptedName;
        if (itemName == null || itemName.isEmpty()) {
            return itemName;
        }
        if (itemName.charAt(0) == '_' && this.schemaFieldList.contains(adaptedName = "$" + itemName.substring(1))) {
            return adaptedName;
        }
        return itemName;
    }

    public String adaptImixsItemName(String itemName) {
        if (itemName == null || itemName.isEmpty() || this.schemaFieldList == null) {
            return itemName;
        }
        if (itemName.charAt(0) == '$' && this.schemaFieldList.contains(itemName)) {
            String adaptedName = "_" + itemName.substring(1);
            return adaptedName;
        }
        return itemName;
    }
}

