/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.imixs.melman.RestAPIException;
import org.imixs.melman.WorkflowClient;
import org.imixs.ml.api.TrainingApplication;
import org.imixs.ml.service.TrainingService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Named
@Path(value="training")
@Produces(value={"application/xml", "application/json"})
public class TrainingResource {
    @Inject
    TrainingService trainingService;
    private static Logger logger = Logger.getLogger(TrainingResource.class.getName());

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response trainData(XMLDocument xmlConfig) {
        int countTotal = 0;
        int countQualityFull = 0;
        int countQualityPartial = 0;
        int countQualityBad = 0;
        ItemCollection config = XMLDocumentAdapter.putDocument((XMLDocument)xmlConfig);
        logger.info("...starting training....");
        try {
            WorkflowClient worklowClient = TrainingApplication.buildWorkflowClient((ItemCollection)config);
            List itemNames = config.getItemValue("workflow.entities");
            if (itemNames.contains("$file") || itemNames.contains("$snapshotid")) {
                logger.severe("$file and $snapshot must not be included in the workflow.entities!");
                System.exit(0);
            }
            String encodedQuery = URLEncoder.encode(config.getItemValueString("workflow.query"), StandardCharsets.UTF_8.toString());
            String queryURL = "documents/search/" + encodedQuery + "?sortBy=$created&sortReverse=true";
            queryURL = queryURL + "&pageSize=" + config.getItemValueInteger("workflow.pagesize") + "&pageIndex=" + config.getItemValueInteger("workflow.pageindex");
            queryURL = TrainingApplication.appendItenNames((String)queryURL, (List)itemNames);
            logger.info("......select workitems: " + queryURL);
            List documents = worklowClient.getCustomResource(queryURL);
            countTotal = documents.size();
            logger.info("...... " + documents.size() + " documents found");
            block6: for (ItemCollection doc : documents) {
                int qualityResult = this.trainingService.trainWorkitemData(config, doc, worklowClient);
                switch (qualityResult) {
                    case 1: {
                        ++countQualityFull;
                        continue block6;
                    }
                    case 2: {
                        ++countQualityPartial;
                        continue block6;
                    }
                }
                ++countQualityBad;
            }
        }
        catch (UnsupportedEncodingException | RestAPIException e) {
            logger.warning("Failed to query documents: " + e.getMessage());
            e.printStackTrace();
        }
        logger.info("**************** FINISHED ***********************");
        ItemCollection stats = new ItemCollection();
        stats.setItemValue("workitems.total", (Object)countTotal);
        stats.setItemValue("workitems.quality.full", (Object)countQualityFull);
        stats.setItemValue("workitems.quality.partial", (Object)countQualityPartial);
        stats.setItemValue("workitems.quality.bad", (Object)countQualityBad);
        DecimalFormat df = new DecimalFormat("###.##");
        String log = "......workitems read in total = " + countTotal + "\n";
        log = log + "  ......           full quality = " + df.format((double)countQualityFull / (double)countTotal * 100.0) + "%  (" + countQualityFull + ")\n";
        log = log + "  ......        partial quality = " + df.format((double)countQualityPartial / (double)countTotal * 100.0) + "%  (" + countQualityPartial + ")\n";
        log = log + "  ......            bad quality = " + df.format((double)countQualityBad / (double)countTotal * 100.0) + "%  (" + countQualityBad + ")\n";
        logger.info(log);
        logger.info("**************** FINISHED ***********************");
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)stats), (String)"application/xml").build();
    }
}

