/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.imixs.melman.RestAPIException;
import org.imixs.melman.WorkflowClient;
import org.imixs.ml.api.TrainingApplication;
import org.imixs.ml.service.TrainingService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Named
@Path(value="testing")
@Produces(value={"application/xml", "application/json"})
public class TestingResource {
    @Inject
    TrainingService trainingService;
    private static Logger logger = Logger.getLogger(TestingResource.class.getName());

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response testingData(XMLDocument xmlConfig) {
        ItemCollection config = XMLDocumentAdapter.putDocument((XMLDocument)xmlConfig);
        logger.info("...starting testing....");
        try {
            WorkflowClient worklowClient = TrainingApplication.buildWorkflowClient((ItemCollection)config);
            String encodedQuery = URLEncoder.encode(config.getItemValueString("workflow.query"), StandardCharsets.UTF_8.toString());
            String queryURL = "documents/search/" + encodedQuery + "?sortBy=$created&sortReverse=true";
            queryURL = queryURL + "&pageSize=" + config.getItemValueInteger("workflow.pagesize") + "&pageIndex=" + config.getItemValueInteger("workflow.pageindex");
            queryURL = TrainingApplication.appendItenNames((String)queryURL, null);
            logger.info("......select workitems: " + queryURL);
            List documents = worklowClient.getCustomResource(queryURL);
            logger.info("...... " + documents.size() + " documents found");
            for (ItemCollection doc : documents) {
                this.trainingService.testWorkitemData(config, doc, worklowClient);
            }
        }
        catch (UnsupportedEncodingException | RestAPIException e) {
            logger.warning("Failed to query documents: " + e.getMessage());
            e.printStackTrace();
        }
        logger.info("**************** FINISHED ***********************");
        return Response.ok((Object)"application/xml").build();
    }
}

