/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.imixs.melman.RestAPIException;
import org.imixs.melman.WorkflowClient;
import org.imixs.ml.api.TrainingApplication;
import org.imixs.ml.core.MLTrainingResult;
import org.imixs.ml.service.TrainingService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.util.JSONParser;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Named
@Path(value="training")
@Produces(value={"application/xml", "application/json"})
public class TrainingResource {
    @Inject
    TrainingService trainingService;
    private static Logger logger = Logger.getLogger(TrainingResource.class.getName());

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response trainData(XMLDocument xmlConfig) {
        int countTotal = 0;
        int countQualityGood = 0;
        int countQualityLow = 0;
        int countQualityBad = 0;
        double nerFactor = -1.0;
        double allNerFactors = 0.0;
        ItemCollection config = XMLDocumentAdapter.putDocument((XMLDocument)xmlConfig);
        logger.info("...starting training....");
        try {
            WorkflowClient worklowClient = TrainingApplication.buildWorkflowClient((ItemCollection)config);
            List itemNames = config.getItemValue("workflow.entities");
            if (itemNames.contains("$file") || itemNames.contains("$snapshotid")) {
                logger.severe("$file and $snapshot must not be included in the workflow.entities!");
                System.exit(0);
            }
            String encodedQuery = URLEncoder.encode(config.getItemValueString("workflow.query"), StandardCharsets.UTF_8.toString());
            String queryURL = "documents/search/" + encodedQuery + "?sortBy=$created&sortReverse=true";
            queryURL = queryURL + "&pageSize=" + config.getItemValueInteger("workflow.pagesize") + "&pageIndex=" + config.getItemValueInteger("workflow.pageindex");
            queryURL = TrainingApplication.appendItenNames((String)queryURL, (List)itemNames);
            logger.info("......select workitems: " + queryURL);
            List documents = worklowClient.getCustomResource(queryURL);
            countTotal = documents.size();
            logger.info("...... " + documents.size() + " documents found");
            int currentCount = 0;
            for (ItemCollection doc : documents) {
                ++currentCount;
                MLTrainingResult trainingResult = this.trainingService.trainWorkitemData(config, doc, worklowClient);
                if (trainingResult != null) {
                    String resultData;
                    switch (trainingResult.getQualityLevel()) {
                        case 10: {
                            ++countQualityGood;
                            break;
                        }
                        case 4: {
                            ++countQualityLow;
                            break;
                        }
                        default: {
                            ++countQualityBad;
                        }
                    }
                    if ((resultData = trainingResult.getData()) == null || resultData.isEmpty()) continue;
                    try {
                        String nerString = JSONParser.getKey((String)"ner", (String)resultData);
                        double newNerFactor = Double.parseDouble(nerString);
                        nerFactor = (allNerFactors += newNerFactor) / (double)currentCount;
                    }
                    catch (Exception e) {
                        logger.severe("failed to parse training result (ner)");
                    }
                    continue;
                }
                ++countQualityBad;
            }
        }
        catch (UnsupportedEncodingException | RestAPIException e) {
            logger.warning("Failed to query documents: " + e.getMessage());
            e.printStackTrace();
        }
        logger.info(" ");
        ItemCollection stats = new ItemCollection();
        stats.setItemValue("workitems.total", (Object)countTotal);
        stats.setItemValue("workitems.quality.good", (Object)countQualityGood);
        stats.setItemValue("workitems.quality.low", (Object)countQualityLow);
        stats.setItemValue("workitems.quality.bad", (Object)countQualityBad);
        stats.setItemValue("workitems.quality.nerFactor", (Object)nerFactor);
        DecimalFormat df = new DecimalFormat("###.##");
        String log = "......workitems read in total = " + countTotal + "\n";
        log = log + "  ......     quality level GOOD = " + df.format((double)countQualityGood / (double)countTotal * 100.0) + "%  (" + countQualityGood + ")\n";
        log = log + "  ......      quality level LOW = " + df.format((double)countQualityLow / (double)countTotal * 100.0) + "%  (" + countQualityLow + ")\n";
        log = log + "  ......      quality level BAD = " + df.format((double)countQualityBad / (double)countTotal * 100.0) + "%  (" + countQualityBad + ")";
        log = log + "\n  ......            average NER = " + nerFactor;
        logger.info(log);
        logger.info("**************** Completed ***********************");
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)stats), (String)"application/xml").build();
    }
}

