/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.api;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Application;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.WorkflowClient;
import org.imixs.workflow.ItemCollection;

@ApplicationPath(value="api")
public class TrainingApplication
extends Application {
    public static final String ITEM_WORKFLOW_ENDPOINT = "workflow.endpoint";
    public static final String ITEM_WORKFLOW_USER = "workflow.userid";
    public static final String ITEM_WORKFLOW_PASSWORD = "workflow.password";
    public static final String ITEM_WORKFLOW_QUERY = "workflow.query";
    public static final String ITEM_WORKFLOW_PAGEINDEX = "workflow.pageindex";
    public static final String ITEM_WORKFLOW_PAGESIZE = "workflow.pagesize";
    public static final String ITEM_ENTITIES = "workflow.entities";
    public static final String ITEM_LOCALES = "workflow.locale";
    public static final String ITEM_TIKA_OPTIONS = "tika.options";
    public static final String ITEM_TIKA_OCR_MODE = "tika.ocrmode";
    public static final String ITEM_ML_TRAINING_ENDPOINT = "ml.training.endpoint";
    public static final String ITEM_ML_TRAINING_MODEL = "ml.training.model";
    public static final String ITEM_ML_TRAINING_QUALITYLEVEL = "ml.training.quality";
    public static final String ITEM_ML_TRAINING_ITERATIONS = "ml.training.iterations";
    public static final String ITEM_ML_TRAINING_DROP_OUT_RATE = "ml.training.dropoutrate";
    public static final String ITEM_ML_TRAINING_OCR = "ml.training.ocr";
    public static final String ITEM_ML_TRAINING_FILEPATTERN = "ml.training.filepattern";
    public static final String ITME_ML_OPTIONS = "ml.options";
    public static final String ITEM_ML_VALIDATION_ENDPOINT = "ml.validation.endpoint";
    public static final String ITEM_ML_VALIDATION_MODEL = "ml.validation.model";
    public static final String ITEM_ML_VALIDATION_OCR = "ml.validation.ocr";
    public static final String ITEM_ML_VALIDATION_FILEPATTERN = "ml.validation.filepattern";
    private static Logger logger = Logger.getLogger(TrainingApplication.class.getName());

    public static WorkflowClient buildWorkflowClient(ItemCollection config) {
        String target = config.getItemValueString(ITEM_WORKFLOW_ENDPOINT);
        logger.info("...workflow.endpoint=" + target);
        logger.info("...workflow.userid=" + config.getItemValueString(ITEM_WORKFLOW_USER));
        WorkflowClient worklowClient = new WorkflowClient(target);
        FormAuthenticator formAuth = new FormAuthenticator(target, config.getItemValueString(ITEM_WORKFLOW_USER), config.getItemValueString(ITEM_WORKFLOW_PASSWORD));
        worklowClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
        return worklowClient;
    }

    public static String appendItenNames(String url, List<String> itemNames) {
        Object queryParam = "&items=$file,$snapshotid,$uniqueid";
        if (itemNames != null) {
            for (String itemName : itemNames) {
                if ((itemName = itemName.toLowerCase().trim()).contains("|")) {
                    itemName = itemName.substring(0, itemName.indexOf(124)).trim();
                }
                queryParam = (String)queryParam + "," + itemName;
            }
        }
        url = (String)url + (String)queryParam;
        return url;
    }
}

