/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.imixs.melman.RestAPIException;
import org.imixs.melman.WorkflowClient;
import org.imixs.ml.api.TrainingApplication;
import org.imixs.ml.core.MLTrainingResult;
import org.imixs.ml.service.TrainingService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.util.JSONParser;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Named
@Path(value="validate")
@Produces(value={"application/xml", "application/json"})
public class ValidateResource {
    @Inject
    TrainingService trainingService;
    private static Logger logger = Logger.getLogger(ValidateResource.class.getName());

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response validateData(XMLDocument xmlConfig) {
        int countTotal = 0;
        int countQualityGood = 0;
        int countQualityLow = 0;
        int countQualityBad = 0;
        double nerFactor = -1.0;
        double allNerFactors = 0.0;
        Object log = "";
        ItemCollection config = XMLDocumentAdapter.putDocument((XMLDocument)xmlConfig);
        logger.info("...starting testing....");
        try {
            WorkflowClient worklowClient = TrainingApplication.buildWorkflowClient((ItemCollection)config);
            List itemNames = config.getItemValue("workflow.entities");
            itemNames.add("ml.definitions");
            if (itemNames.contains("$file") || itemNames.contains("$snapshotid")) {
                logger.severe("$file and $snapshot must not be included in the workflow.entities!");
                System.exit(0);
            }
            String encodedQuery = URLEncoder.encode(config.getItemValueString("workflow.query"), StandardCharsets.UTF_8.toString());
            Object queryURL = "documents/search/" + encodedQuery + "?sortBy=$created&sortReverse=true";
            queryURL = (String)queryURL + "&pageSize=" + config.getItemValueInteger("workflow.pagesize") + "&pageIndex=" + config.getItemValueInteger("workflow.pageindex");
            queryURL = TrainingApplication.appendItenNames((String)queryURL, (List)itemNames);
            logger.info("......select workitems: " + (String)queryURL);
            List documents = worklowClient.getCustomResource((String)queryURL);
            logger.info("...... " + documents.size() + " documents found");
            int currentCount = 0;
            for (ItemCollection doc : documents) {
                MLTrainingResult trainingResult = this.trainingService.validateWorkitemData(config, doc, worklowClient);
                ++currentCount;
                ++countTotal;
                if (trainingResult != null) {
                    String resultData;
                    switch (trainingResult.getQualityLevel()) {
                        case 10: {
                            ++countQualityGood;
                            break;
                        }
                        case 4: {
                            ++countQualityLow;
                            break;
                        }
                        default: {
                            ++countQualityBad;
                        }
                    }
                    if ((resultData = trainingResult.getData()) == null || resultData.isEmpty()) continue;
                    try {
                        String nerString = JSONParser.getKey((String)"ner", (String)resultData);
                        double newNerFactor = Double.parseDouble(nerString);
                        nerFactor = (allNerFactors += newNerFactor) / (double)currentCount;
                    }
                    catch (Exception e) {
                        logger.severe("failed to parse training result (ner)");
                    }
                    continue;
                }
                ++countQualityBad;
            }
        }
        catch (UnsupportedEncodingException | RestAPIException e) {
            logger.warning("Failed to query documents: " + e.getMessage());
            e.printStackTrace();
        }
        logger.info("**************** FINISHED ***********************");
        DecimalFormat df = new DecimalFormat("###.##");
        log = (String)log + "  ......   quality level GOOD = " + df.format((double)countQualityGood / (double)countTotal * 100.0) + "%  (" + countQualityGood + ")\n";
        log = (String)log + "  ......      quality level LOW = " + df.format((double)countQualityLow / (double)countTotal * 100.0) + "%  (" + countQualityLow + ")\n";
        log = (String)log + "  ......      quality level BAD = " + df.format((double)countQualityBad / (double)countTotal * 100.0) + "%  (" + countQualityBad + ")";
        log = (String)log + "\n  ......            average NER = " + nerFactor;
        log = (String)log + "\n";
        logger.info((String)log);
        return Response.ok((Object)"application/xml").build();
    }
}

