/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.workflow;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.ml.core.MLClient;
import org.imixs.ml.events.EntityObjectEvent;
import org.imixs.ml.training.TrainingDataBuilder;
import org.imixs.ml.xml.XMLTrainingData;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.ModelException;

@Stateless
@LocalBean
public class MLService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MLService.class.getName());
    public static final String ITEM_ML_ITEMES = "ml.items";
    public static final String ITEM_ML_STATUS = "ml.status";
    public static final String ML_SERVICE_ENDPOINT = "ml.service.endpoint";
    public static final String ML_LOCALES = "ml.locales";
    public static final String ML_STATUS_SUGGEST = "suggest";
    public static final String ML_STATUS_CONFIRMED = "confirmed";
    public static final String ML_STATUS_TRAINING = "training";
    public static final String EVENTLOG_TOPIC_TRAINING = "ml.training";
    @Inject
    @ConfigProperty(name="ml.service.endpoint")
    Optional<String> mlAPIEndpoint;
    @Inject
    @ConfigProperty(name="ml.locales", defaultValue="DE,UK")
    String mlDefaultLocales;
    @Inject
    protected Event<EntityObjectEvent> entityObjectEvents;
    @Inject
    protected ModelService modelService;
    @Inject
    protected WorkflowService workflowService;
    @Inject
    protected EventLogService eventLogService;

    public void onWorkflowEvent(@Observes ProcessingEvent processingEvent) {
        if (processingEvent == null) {
            return;
        }
        ItemCollection workitem = processingEvent.getDocument();
        if (workitem != null && !workitem.getItemValueString("type").startsWith("workitem")) {
            return;
        }
        if (!this.mlAPIEndpoint.isPresent() || this.mlAPIEndpoint.get().isEmpty()) {
            return;
        }
        int eventType = processingEvent.getEventType();
        List mlItems = workitem.getItemValue(ITEM_ML_ITEMES);
        if (2 == eventType && mlItems.size() > 0 && workitem.getItemValueString(ITEM_ML_STATUS).isEmpty()) {
            workitem.setItemValue(ITEM_ML_STATUS, (Object)ML_STATUS_SUGGEST);
            return;
        }
        if (1 == eventType && mlItems.size() > 0 && ML_STATUS_SUGGEST.equals(workitem.getItemValueString(ITEM_ML_STATUS))) {
            try {
                Model model = this.modelService.getModelByWorkitem(workitem);
                ItemCollection event = model.getEvent(workitem.getTaskID(), workitem.getEventID());
                if (!"0".equals(event.getItemValueString("keypublicresult"))) {
                    workitem.setItemValue(ITEM_ML_STATUS, (Object)ML_STATUS_CONFIRMED);
                    return;
                }
            }
            catch (ModelException e) {
                logger.warning("unable to parse current bpmn event: " + e.getMessage());
            }
        }
        if (2 == eventType && ML_STATUS_CONFIRMED.equals(workitem.getItemValueString(ITEM_ML_STATUS)) && "workitemarchive".equals(workitem.getType())) {
            workitem.setItemValue(ITEM_ML_STATUS, (Object)ML_STATUS_TRAINING);
            this.eventLogService.createEvent(EVENTLOG_TOPIC_TRAINING, workitem.getUniqueID());
        }
    }

    public String getAllDocumentText(ItemCollection workitem) {
        if (workitem == null) {
            return null;
        }
        String result = "";
        List fileDataList = workitem.getFileData();
        for (FileData fileData : fileDataList) {
            List fileText = (List)fileData.getAttribute("text");
            if (fileText == null || fileText.size() <= 0) continue;
            result = result + fileText.get(0) + " ";
        }
        return result;
    }

    public void trainWorkitem(String uid) {
        ItemCollection workitem = this.workflowService.getWorkItem(uid);
        if (workitem != null && this.mlAPIEndpoint.isPresent() && !this.mlAPIEndpoint.get().isEmpty()) {
            MLClient mlClient = new MLClient();
            String content = this.getAllDocumentText(workitem);
            List itemNames = workitem.getItemValue(ITEM_ML_ITEMES);
            Set<Locale> locales = this.parseMLLocales();
            XMLTrainingData trainingData = new TrainingDataBuilder(content, workitem, itemNames, locales).setAnalyzerEntityEvents(this.entityObjectEvents).build();
            mlClient.postTrainingData(trainingData, this.mlAPIEndpoint.get());
        }
    }

    private Set<Locale> parseMLLocales() {
        String[] sLocales;
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        HashSet<Locale> locals = new HashSet<Locale>();
        for (String _locale : sLocales = this.mlDefaultLocales.split(",")) {
            Locale aLocale = new Locale(_locale);
            locals.add(aLocale);
            if (!debug) continue;
            logger.info("......suporting locale " + aLocale);
        }
        return locals;
    }
}

