/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.workflow;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.ml.workflow.MLService;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.jpa.EventLog;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Startup
@Singleton
@LocalBean
public class MLTrainingScheduler {
    public static final String ML_TRAINING_SCHEDULER_ENABLED = "ml.trainng.scheduler.enabled";
    public static final String ML_TRAINING_SCHEDULER_INTERVAL = "ml.training.scheduler.interval";
    public static final String ML_TRAINING_SCHEDULER_INITIALDELAY = "ml.training.scheduler.initialdelay";
    @Inject
    @ConfigProperty(name="ml.trainng.scheduler.enabled", defaultValue="false")
    boolean enabled;
    @Inject
    @ConfigProperty(name="ml.service.endpoint")
    Optional<String> mlAPIEndpoint;
    @Inject
    @ConfigProperty(name="ml.training.scheduler.interval", defaultValue="600000")
    long interval;
    @Inject
    @ConfigProperty(name="ml.training.scheduler.initialdelay", defaultValue="60000")
    long initialDelay;
    private static Logger logger = Logger.getLogger(MLTrainingScheduler.class.getName());
    @Resource
    TimerService timerService;
    @Inject
    MLService mlService;
    @Inject
    EventLogService eventLogService;

    @PostConstruct
    public void init() {
        if (this.enabled) {
            logger.info("Starting MLTrainingScheduler - initalDelay=" + this.initialDelay + "  inverval=" + this.interval + " ....");
            if (this.mlAPIEndpoint.isPresent() && !this.mlAPIEndpoint.get().isEmpty()) {
                TimerConfig timerConfig = new TimerConfig();
                timerConfig.setInfo((Serializable)((Object)"Imixs-Workflow MLTrainingScheduler"));
                timerConfig.setPersistent(false);
                this.timerService.createIntervalTimer(this.initialDelay, this.interval, timerConfig);
            } else {
                logger.severe("Scheduler  can not be started because no valid ML Service Endpoint was defined. Verfify environment parameter 'ML_SERVICE_ENDPOINT'");
            }
        }
    }

    @Timeout
    public void run(Timer timer) {
        long l = System.currentTimeMillis();
        boolean debug = logger.isLoggable(Level.FINE);
        List events = this.eventLogService.findEventsByTimeout(10, new String[]{"ml.training"});
        if (events.size() > 0) {
            logger.finest("...starting ml training. " + events.size() + " new MLTrainingEvents found....");
        }
        for (EventLog eventLogEntry : events) {
            this.mlService.trainWorkitem(eventLogEntry.getRef());
        }
        if (debug) {
            logger.fine("..." + events.size() + " MLTrainingEvents processed in " + (System.currentTimeMillis() - l) + "ms");
        }
    }
}

