/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.ml.core.MLClient;
import org.imixs.ml.events.EntityTextEvent;
import org.imixs.ml.xml.XMLAnalyseEntity;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;
import util.LocaleHelper;

public class MLAdapter
implements SignalAdapter {
    public static final String ML_ENTITY = "entity";
    public static final String PLUGIN_ERROR = "PLUGIN_ERROR";
    public static final int API_EVENT_SUCCESS = 110;
    public static final int API_EVENT_FAILURE = 90;
    private static Logger logger = Logger.getLogger(MLAdapter.class.getName());
    @Inject
    @ConfigProperty(name="ml.service.endpoint")
    Optional<String> mlDefaultAPIEndpoint;
    @Inject
    @ConfigProperty(name="ml.locales", defaultValue="de_DE,en_GB")
    private String mlDefaultLocales;
    @Inject
    private WorkflowService workflowService;
    @Inject
    private Event<EntityTextEvent> entityTextEvents = null;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        String mlAPIEndpoint = null;
        List<Object> locals = new ArrayList();
        Map<String, EntityDefinition> entityDefinitions = null;
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        logger.finest("...running api adapter...");
        try {
            ItemCollection mlConfig = this.workflowService.evalWorkflowResult(event, "ml-config", document, false);
            mlAPIEndpoint = this.parseMLEndpointByModel(mlConfig);
            locals = this.parseMLLocalesByModel(mlConfig);
            entityDefinitions = this.parseEntityDefinitionsByModel(mlConfig);
        }
        catch (PluginException e) {
            logger.warning("Unable to parse item definitions for 'ml-config', verify model - " + e.getMessage());
        }
        if (mlAPIEndpoint == null || mlAPIEndpoint.isEmpty()) {
            throw new AdapterException(MLAdapter.class.getSimpleName(), PLUGIN_ERROR, "imixs-ml service endpoint is empty!");
        }
        if (mlAPIEndpoint.indexOf("/analyse") > -1) {
            throw new AdapterException(MLAdapter.class.getSimpleName(), PLUGIN_ERROR, "imixs-ml wrong service endpoint - should not contain \"/analyzse\" resource!");
        }
        if (!mlAPIEndpoint.endsWith("/")) {
            mlAPIEndpoint = mlAPIEndpoint + "/";
        }
        mlAPIEndpoint = mlAPIEndpoint + "analyse/";
        List files = document.getFileData();
        if (files != null && files.size() > 0) {
            for (FileData file : files) {
                logger.info("...analyzing content of '" + file.getName() + "'.....");
                ItemCollection metadata = new ItemCollection(file.getAttributes());
                String ocrText = metadata.getItemValueString("text");
                MLClient mlClient = new MLClient();
                List result = mlClient.postAnalyseData(ocrText, mlAPIEndpoint);
                Map<String, List<String>> groupedEntityList = this.groupTextValues(result);
                for (Map.Entry<String, List<String>> mlEntity : groupedEntityList.entrySet()) {
                    EntityDefinition entityDef;
                    String mlEntityName = mlEntity.getKey();
                    if (!entityDefinitions.containsKey(mlEntityName) || !document.isItemEmpty((entityDef = entityDefinitions.get(mlEntityName)).getItemName())) continue;
                    List<String> itemValueList = mlEntity.getValue();
                    EntityTextEvent entityTextEvent = new EntityTextEvent(itemValueList, locals, entityDef.getItemType());
                    this.entityTextEvents.fire((Object)entityTextEvent);
                    if (entityTextEvent.getItemValue() != null) {
                        if (debug) {
                            logger.info("Best match=" + entityTextEvent.getItemValue());
                        }
                        document.setItemValue(entityDef.getItemName(), entityTextEvent.getItemValue());
                        continue;
                    }
                    document.setItemValue(entityDef.getItemName(), (Object)mlEntity.getValue().iterator().next());
                }
                document.setItemValue("ml.items", entityDefinitions.keySet());
            }
        } else {
            logger.finest("......no files found for " + document.getUniqueID());
        }
        return document;
    }

    private String parseMLEndpointByModel(ItemCollection mlConfig) {
        boolean debug = logger.isLoggable(Level.FINE);
        debug = true;
        String mlAPIEndpoint = null;
        mlAPIEndpoint = null;
        if (mlConfig != null) {
            mlAPIEndpoint = mlConfig.getItemValueString("endpoint");
        }
        if ((mlAPIEndpoint == null || mlAPIEndpoint.isEmpty()) && this.mlDefaultAPIEndpoint.isPresent() && !this.mlDefaultAPIEndpoint.get().isEmpty()) {
            mlAPIEndpoint = this.mlDefaultAPIEndpoint.get();
        }
        if (debug) {
            logger.info("......ml api endpoint " + mlAPIEndpoint);
        }
        return mlAPIEndpoint;
    }

    private List<Locale> parseMLLocalesByModel(ItemCollection mlConfig) {
        String mlAPILocales = null;
        if (mlConfig != null) {
            mlAPILocales = mlConfig.getItemValueString("locales");
        }
        if (mlAPILocales == null || mlAPILocales.isEmpty()) {
            mlAPILocales = this.mlDefaultLocales;
        }
        return LocaleHelper.parseLocales((String)mlAPILocales);
    }

    private Map<String, EntityDefinition> parseEntityDefinitionsByModel(ItemCollection mlConfig) {
        List entityDevList = mlConfig.getItemValue(ML_ENTITY);
        HashMap<String, EntityDefinition> result = new HashMap<String, EntityDefinition>();
        for (String entityDev : entityDevList) {
            if (entityDev.trim().isEmpty()) continue;
            try {
                ItemCollection entityData = XMLParser.parseItemStructure((String)entityDev);
                if (entityData == null) continue;
                String name = entityData.getItemValueString("name");
                String type = entityData.getItemValueString("type");
                String mapping = entityData.getItemValueString("mapping");
                result.put(name, new EntityDefinition(name, type, mapping));
            }
            catch (PluginException e) {
                logger.warning("Invalid ml.config definition with unexpected entity element - verify model!");
            }
        }
        return result;
    }

    private Map<String, List<String>> groupTextValues(List<XMLAnalyseEntity> data) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (data != null) {
            for (XMLAnalyseEntity entity : data) {
                String itemName = entity.getLabel();
                String itemValue = entity.getText();
                if (itemName == null || itemName.isEmpty() || itemValue == null || itemValue.isEmpty()) continue;
                List<String> textList = result.get(itemName);
                if (textList == null) {
                    textList = new ArrayList<String>();
                }
                textList.add(itemValue);
                result.put(itemName.trim(), textList);
            }
        }
        return result;
    }

    class EntityDefinition {
        private String name;
        private String itemType;
        private String itemName;

        public EntityDefinition(String name, String itemType, String itemName) {
            if (name == null || name.isEmpty()) {
                logger.warning("Invalid ml.config entity definition - missing name!");
            }
            this.name = name;
            this.itemType = itemType;
            this.itemName = itemName;
        }

        public String getName() {
            return this.name;
        }

        public String getItemType() {
            return this.itemType;
        }

        public String getItemName() {
            if (this.itemName == null || this.itemName.isEmpty()) {
                return this.name;
            }
            return this.itemName;
        }
    }
}

