/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.ml.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.ConversationScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.ml.core.MLConfig;
import org.imixs.ml.workflow.MLService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.faces.data.WorkflowController;

@Named(value="mlController")
@ConversationScoped
public class MLController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MLController.class.getName());
    public static List<String> STOP_PHRASE_LIST = Arrays.asList("\n", "  ", ", ", ". ", ".\n");
    @Inject
    protected WorkflowController workflowController;
    @Inject
    protected MLService mlService;
    private List<String> searchResult = null;

    public boolean isMLItem(String name) {
        List<ItemCollection> mlDefinitionList;
        Iterator<ItemCollection> iterator;
        if (this.workflowController.getWorkitem() != null && (iterator = (mlDefinitionList = this.mlService.getMLDefinitions(this.workflowController.getWorkitem())).iterator()).hasNext()) {
            ItemCollection mlDefinition = iterator.next();
            List definitionMap = mlDefinition.getItemValue("ml.items");
            List mlEntities = MLConfig.explodeMLEntityList((List)definitionMap);
            List mlItems = MLConfig.getAllEntityNames((List)mlEntities);
            return mlItems.contains(name);
        }
        return false;
    }

    public String getMLResult() {
        String result = "{";
        String status = "confirmed";
        if (this.workflowController.getWorkitem() != null) {
            ArrayList mlItems = new ArrayList();
            List<ItemCollection> mlDefinitionList = this.mlService.getMLDefinitions(this.workflowController.getWorkitem());
            for (ItemCollection mlDefinition : mlDefinitionList) {
                List definitionMap = mlDefinition.getItemValue("ml.items");
                List mlEntities = MLConfig.explodeMLEntityList((List)definitionMap);
                mlItems.addAll(MLConfig.getAllEntityNames((List)mlEntities));
                if (!"suggest".equals(mlDefinition.getItemValueString("ml.status"))) continue;
                status = "suggest";
            }
            result = result + "\"status\":\"" + status + "\"";
            if (mlItems != null && mlItems.size() > 0) {
                result = result + ",\"items\":";
                result = result + mlItems.stream().map(n -> "\"" + n + "\"").collect(Collectors.joining(",", "[", "]"));
            }
        } else {
            result = result + "\"status\":\"none\"";
        }
        result = result + "}";
        return result;
    }

    public void search() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String phrase = (String)fc.getExternalContext().getRequestParameterMap().get("phrase");
        logger.finest("search prase '" + phrase + "'");
        if (phrase == null || phrase.length() < 2) {
            return;
        }
        logger.fine("search for=" + phrase);
        this.searchResult = new ArrayList<String>();
        String text = this.mlService.getAllDocumentText(this.workflowController.getWorkitem());
        if (text != null) {
            this.searchResult = MLController.findMatches(phrase, text);
        }
    }

    public static List<String> findMatches(String phrase, String _text) {
        String searchPhrase;
        ArrayList<String> result = new ArrayList<String>();
        String text = _text + " ";
        String searchText = text.toLowerCase();
        String originSearchPhrase = searchPhrase = phrase.toLowerCase();
        int index = 0;
        do {
            int found;
            if ((found = searchText.indexOf(searchPhrase, index)) > -1) {
                String hit = null;
                boolean tailingSpace = false;
                int endPos = -1;
                int nextSpacePos = searchText.indexOf(" ", found + searchPhrase.length() + 0);
                int nextStopPhrase = MLController.indexOfStopPhrase(searchText, found + searchPhrase.length() + 0);
                if (nextStopPhrase > -1) {
                    endPos = nextStopPhrase;
                    if (nextSpacePos > -1 && nextSpacePos < nextStopPhrase) {
                        endPos = nextSpacePos;
                        tailingSpace = true;
                    }
                } else if (nextSpacePos > -1) {
                    endPos = nextSpacePos;
                    tailingSpace = true;
                }
                if (endPos > -1) {
                    hit = text.substring(found, endPos).trim();
                }
                if (hit != null) {
                    if (hit.length() > 64) {
                        hit = hit.substring(0, 64).trim();
                    }
                    if (!result.contains(hit) && !MLController.endsWithSpecialCharacter(hit)) {
                        result.add(hit);
                    }
                    if (tailingSpace && !searchPhrase.equals(hit.toLowerCase() + " ")) {
                        searchPhrase = hit.toLowerCase() + " ";
                        continue;
                    }
                    searchPhrase = originSearchPhrase;
                    index = found + hit.length() + 1;
                    continue;
                }
                break;
            }
            if (searchPhrase.equals(originSearchPhrase)) break;
            index = index + searchPhrase.length() + 1;
            searchPhrase = originSearchPhrase;
        } while (result.size() < 12);
        return result;
    }

    public static boolean endsWithSpecialCharacter(String s) {
        char c = s.charAt(s.length() - 1);
        if (c >= '\"' && c <= '/' || c >= ':' && c <= '@' || c == '\n' || c == '\t') {
            return true;
        }
        if (c >= '\u00a1' && c <= '\u00bf') {
            return true;
        }
        return c >= '\u2000';
    }

    public static int indexOfStopPhrase(String searchText, int fromIndex) {
        int stopPhrasePos = -1;
        int bestMatch = 99999999;
        for (String stopPhrase : STOP_PHRASE_LIST) {
            int match = searchText.indexOf(stopPhrase, fromIndex);
            if (match <= -1 || match >= bestMatch) continue;
            stopPhrasePos = bestMatch = match;
        }
        return stopPhrasePos;
    }

    @Deprecated
    public static List<String> findMatchesOld(String phrase, String _text) {
        int found;
        String searchPhrase;
        ArrayList<String> result = new ArrayList<String>();
        String text = _text;
        text = text.replace("\n", " ");
        String searchText = text.toLowerCase();
        String originSearchPhrase = searchPhrase = phrase.toLowerCase();
        int index = 0;
        while ((found = searchText.indexOf(searchPhrase, index)) > -1) {
            String hit = null;
            int endPos = searchText.indexOf(" ", found + searchPhrase.length() + 1);
            if (endPos == -1) {
                endPos = searchText.indexOf(".", found + searchPhrase.length() + 1);
            }
            if (endPos == -1) {
                endPos = searchText.indexOf("\n", found + searchPhrase.length() + 1);
            }
            if ((hit = endPos > -1 ? text.substring(found, endPos).trim() : text.substring(found).trim()).length() > 64) {
                hit = hit.substring(0, 64).trim();
            }
            if (!result.contains(hit)) {
                result.add(hit);
                if (!searchPhrase.endsWith(" ")) {
                    searchPhrase = hit.toLowerCase() + " ";
                } else {
                    searchPhrase = originSearchPhrase;
                    index = found + hit.length();
                }
            } else {
                index = found + hit.length();
            }
            if (result.size() < 12) continue;
            break;
        }
        return result;
    }

    public List<String> getSearchResult() {
        return this.searchResult;
    }

    public void reset() {
        this.searchResult = new ArrayList<String>();
        logger.fine("reset");
    }
}

