/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.SessionContext;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.bpmn.BPMNParser;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.TextItemValueAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.xml.sax.SAXException;

public class WorkflowMockEnvironment {
    private static final Logger logger = Logger.getLogger(WorkflowMockEnvironment.class.getName());
    public static final String DEFAULT_MODEL_VERSION = "1.0.0";
    Map<String, ItemCollection> database = null;
    @Spy
    protected DocumentService documentService;
    @Spy
    protected WorkflowService workflowService;
    @Spy
    protected ModelService modelService;
    protected SessionContext ctx;
    protected WorkflowContext workflowContext;
    private BPMNModel model = null;
    private String modelPath = null;

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public WorkflowContext getWorkflowContext() {
        return this.workflowContext;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    @Before
    public void setup() throws PluginException, ModelException, AdapterException {
        MockitoAnnotations.initMocks((Object)this);
        this.createTestDatabase();
        this.ctx = (SessionContext)Mockito.mock(SessionContext.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)"manfred");
        Mockito.when((Object)this.ctx.getCallerPrincipal()).thenReturn((Object)principal);
        this.documentService = (DocumentService)Mockito.mock(DocumentService.class);
        Mockito.when((Object)this.documentService.load(Mockito.anyString())).thenAnswer((Answer)new Answer<ItemCollection>(){

            public ItemCollection answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                String id = (String)args[0];
                ItemCollection result = WorkflowMockEnvironment.this.database.get(id);
                if (result != null) {
                    result.replaceItemValue("$isAuthor", (Object)true);
                }
                return result;
            }
        });
        Mockito.when((Object)this.documentService.save((ItemCollection)Mockito.any(ItemCollection.class))).thenAnswer((Answer)new Answer<ItemCollection>(){

            public ItemCollection answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                ItemCollection entity = (ItemCollection)args[0];
                if (entity.getUniqueID().isEmpty()) {
                    entity.replaceItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
                }
                WorkflowMockEnvironment.this.database.put(entity.getItemValueString("$uniqueid"), entity);
                return entity;
            }
        });
        ((ModelService)Mockito.doNothing().when((Object)this.modelService)).init();
        this.loadModel();
        ModelManager modelManager = (ModelManager)Mockito.mock(ModelManager.class);
        try {
            Mockito.when((Object)modelManager.getModel(Mockito.anyString())).thenReturn((Object)this.getModel());
            Mockito.when((Object)modelManager.getModelByWorkitem((ItemCollection)Mockito.any(ItemCollection.class))).thenReturn((Object)this.getModel());
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        this.workflowContext = (WorkflowContext)Mockito.mock(WorkflowContext.class);
        Mockito.when((Object)this.workflowContext.getModelManager()).thenReturn((Object)modelManager);
        this.workflowService = (WorkflowService)Mockito.mock(WorkflowService.class);
        this.workflowService.documentService = this.documentService;
        this.workflowService.ctx = this.ctx;
        this.workflowService.modelService = this.modelService;
        Mockito.when((Object)this.workflowService.getModelManager()).thenReturn((Object)this.modelService);
        Mockito.when((Object)this.workflowService.getWorkListByRef(Mockito.anyString())).thenAnswer((Answer)new Answer<List<ItemCollection>>(){

            public List<ItemCollection> answer(InvocationOnMock invocation) throws Throwable {
                ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
                Object[] args = invocation.getArguments();
                String id = (String)args[0];
                Collection<ItemCollection> allEntities = WorkflowMockEnvironment.this.database.values();
                for (ItemCollection aentity : allEntities) {
                    if (!aentity.getItemValueString("$uniqueidref").equals(id)) continue;
                    result.add(aentity);
                }
                return result;
            }
        });
        Mockito.when((Object)this.workflowService.adaptText(Mockito.anyString(), (ItemCollection)Mockito.any(ItemCollection.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable, PluginException {
                Object[] args = invocation.getArguments();
                String text = (String)args[0];
                ItemCollection document = (ItemCollection)args[1];
                TextEvent textEvent = new TextEvent(text, document);
                TextItemValueAdapter tiva = new TextItemValueAdapter();
                tiva.onEvent(textEvent);
                return textEvent.getText();
            }
        });
        Mockito.when((Object)this.workflowService.adaptTextList(Mockito.anyString(), (ItemCollection)Mockito.any(ItemCollection.class))).thenAnswer((Answer)new Answer<List<String>>(){

            public List<String> answer(InvocationOnMock invocation) throws Throwable, PluginException {
                Object[] args = invocation.getArguments();
                String text = (String)args[0];
                ItemCollection document = (ItemCollection)args[1];
                TextEvent textEvent = new TextEvent(text, document);
                TextItemValueAdapter tiva = new TextItemValueAdapter();
                tiva.onEvent(textEvent);
                return textEvent.getTextList();
            }
        });
        Mockito.when((Object)this.workflowService.evalNextTask((ItemCollection)Mockito.any(ItemCollection.class), (ItemCollection)Mockito.any(ItemCollection.class))).thenCallRealMethod();
        Mockito.when((Object)this.workflowService.evalWorkflowResult((ItemCollection)Mockito.any(ItemCollection.class), (ItemCollection)Mockito.any(ItemCollection.class))).thenCallRealMethod();
        Mockito.when((Object)this.workflowService.evalWorkflowResult((ItemCollection)Mockito.any(ItemCollection.class), (ItemCollection)Mockito.any(ItemCollection.class), Mockito.anyBoolean())).thenCallRealMethod();
        Mockito.when((Object)this.workflowService.processWorkItem((ItemCollection)Mockito.any(ItemCollection.class))).thenCallRealMethod();
        Mockito.when((Object)this.workflowService.getUserName()).thenCallRealMethod();
        Mockito.when((Object)this.workflowService.getWorkItem(Mockito.anyString())).thenCallRealMethod();
        ((WorkflowService)Mockito.doCallRealMethod().when((Object)this.workflowService)).registerPlugins((WorkflowKernel)Mockito.any(WorkflowKernel.class), (Model)Mockito.any(Model.class));
        ((WorkflowService)Mockito.doCallRealMethod().when((Object)this.workflowService)).registerAdapters((WorkflowKernel)Mockito.any(WorkflowKernel.class));
        ((WorkflowService)Mockito.doCallRealMethod().when((Object)this.workflowService)).updateWorkitem((ItemCollection)Mockito.any(ItemCollection.class));
        try {
            Mockito.when((Object)this.workflowService.getEvents((ItemCollection)Mockito.any(ItemCollection.class))).thenCallRealMethod();
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    protected void createTestDatabase() {
        this.database = new HashMap<String, ItemCollection>();
        ItemCollection entity = null;
        logger.info("createSimpleDatabase....");
        for (int i = 1; i < 6; ++i) {
            entity = new ItemCollection();
            entity.replaceItemValue("type", (Object)"workitem");
            entity.replaceItemValue("$uniqueid", (Object)("W0000-0000" + i));
            entity.replaceItemValue("txtName", (Object)("Workitem " + i));
            entity.setModelVersion(DEFAULT_MODEL_VERSION);
            entity.setTaskID(100);
            entity.setEventID(10);
            entity.replaceItemValue("$isAuthor", (Object)true);
            this.database.put(entity.getItemValueString("$uniqueid"), entity);
        }
    }

    public Model getModel() {
        return this.model;
    }

    public void loadModel(String modelPath) {
        this.setModelPath(modelPath);
        this.loadModel();
    }

    public void loadModel() {
        if (this.modelPath != null) {
            long lLoadTime = System.currentTimeMillis();
            InputStream inputStream = WorkflowMockEnvironment.class.getResourceAsStream(this.modelPath);
            try {
                logger.info("loading model: " + this.modelPath + "....");
                this.model = BPMNParser.parseModel((InputStream)inputStream, (String)"UTF-8");
                this.modelService.addModel((Model)this.model);
                logger.fine("...loadModel processing time=" + (System.currentTimeMillis() - lLoadTime) + "ms");
            }
            catch (IOException | ParseException | ParserConfigurationException | ModelException | SAXException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, ItemCollection> getDatabase() {
        return this.database;
    }

    public ItemCollection processWorkItem(ItemCollection workitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException, AdapterException {
        workitem = this.workflowService.processWorkItem(workitem);
        return workitem;
    }
}

