/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.Adapter;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.TextForEachAdapter;
import org.imixs.workflow.engine.TextItemValueAdapter;
import org.imixs.workflow.engine.WorkflowContextMock;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.adapters.AccessAdapter;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.junit.jupiter.api.Assertions;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Answer;
import org.openbpmn.bpmn.BPMNModel;
import org.openbpmn.bpmn.exceptions.BPMNModelException;
import org.openbpmn.bpmn.util.BPMNModelFactory;

@MockitoSettings(strictness=Strictness.WARN)
public class WorkflowMockEnvironment {
    protected static final Logger logger = Logger.getLogger(WorkflowMockEnvironment.class.getName());
    protected Map<String, ItemCollection> database = null;
    @Mock
    protected DocumentService documentService;
    @InjectMocks
    protected ModelService modelService;
    @InjectMocks
    protected WorkflowService workflowService;
    @InjectMocks
    protected AccessAdapter accessAdapter;
    protected WorkflowContextMock workflowContext = null;
    protected List<Adapter> adapterList = new ArrayList<Adapter>();

    public ModelService getModelService() {
        return this.modelService;
    }

    public WorkflowContextMock getWorkflowContext() {
        return this.workflowContext;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void registerAdapter(Adapter adapter) {
        this.adapterList.add(adapter);
    }

    public void setUp() throws PluginException {
        MockitoAnnotations.openMocks((Object)this);
        this.createTestDatabase();
        this.workflowService.modelService = this.modelService;
        this.modelService.modelManager = new ModelManager();
        Assertions.assertNotNull((Object)this.modelService.getModelManager());
        this.workflowContext = new WorkflowContextMock();
        this.workflowService.ctx = this.workflowContext.getSessionContext();
        Mockito.when((Object)this.documentService.load(Mockito.anyString())).thenAnswer((Answer)new Answer<ItemCollection>(){

            public ItemCollection answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                String id = (String)args[0];
                ItemCollection result = WorkflowMockEnvironment.this.database.get(id);
                if (result != null) {
                    result.replaceItemValue("$isAuthor", (Object)true);
                }
                return result;
            }
        });
        Mockito.when((Object)this.documentService.save((ItemCollection)Mockito.any())).thenAnswer((Answer)new Answer<ItemCollection>(){

            public ItemCollection answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                ItemCollection data = (ItemCollection)args[0];
                if (data != null) {
                    WorkflowMockEnvironment.this.database.put(data.getUniqueID(), data);
                }
                return data;
            }
        });
        Event mockTextEvents = (Event)Mockito.mock(Event.class);
        ((Event)Mockito.doAnswer(invocation -> {
            TextEvent event = (TextEvent)invocation.getArgument(0);
            TextItemValueAdapter tiva = new TextItemValueAdapter();
            TextForEachAdapter tfea = new TextForEachAdapter();
            tfea.onEvent(event);
            tiva.onEvent(event);
            return null;
        }).when((Object)mockTextEvents)).fire((Object)((TextEvent)Mockito.any(TextEvent.class)));
        this.injectMockIntoField(this.workflowService, "textEvents", mockTextEvents);
        this.registerAdapter((Adapter)this.accessAdapter);
        this.accessAdapter.setWorkflowService(this.getWorkflowService());
        Instance mockAdapters = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockAdapters.iterator()).thenAnswer(invocation -> this.adapterList.iterator());
        Mockito.when((Object)((Adapter)mockAdapters.get())).thenAnswer(invocation -> this.adapterList.isEmpty() ? null : this.adapterList.get(0));
        this.injectMockIntoField(this.workflowService, "adapters", mockAdapters);
    }

    public void loadBPMNModel(String modelPath) {
        try {
            BPMNModel model = BPMNModelFactory.read((String)modelPath);
            this.modelService.getModelManager().addModel(model);
        }
        catch (ModelException | BPMNModelException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    protected void createTestDatabase() {
        this.database = new HashMap<String, ItemCollection>();
        ItemCollection entity = null;
        logger.info("createSimpleDatabase....");
        for (int i = 1; i < 6; ++i) {
            entity = new ItemCollection();
            entity.replaceItemValue("type", (Object)"workitem");
            entity.replaceItemValue("$uniqueid", (Object)("W0000-0000" + i));
            entity.replaceItemValue("txtName", (Object)("Workitem " + i));
            entity.setModelVersion("1.0.0");
            entity.setTaskID(100);
            entity.setEventID(10);
            entity.replaceItemValue("$isAuthor", (Object)true);
            this.database.put(entity.getItemValueString("$uniqueid"), entity);
        }
    }

    public void injectMockIntoField(Object targetObject, String fieldName, Object value) {
        try {
            Field field = targetObject.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(targetObject, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to inject mock into field: " + fieldName, e);
        }
    }
}

