/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.oidc;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.wildfly.security.http.oidc.IDToken;
import org.wildfly.security.http.oidc.OidcSecurityContext;

@RequestScoped
@Path(value="/oidc")
@Produces(value={"text/plain"})
public class WildflyLoginBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(WildflyLoginBean.class.getName());
    @Inject
    Principal principal;

    @GET
    @Produces(value={"text/plain"})
    public String sessionInfoAuth() {
        Object message = "";
        try {
            logger.info("Imixs-Security-OIDC - collecting context information... (see details in server log)");
            System.out.println("=========================================");
            if (this.principal != null) {
                System.out.println("  Principal name: " + this.principal.getName());
            } else {
                System.out.println("  Principal resolved to null!");
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            if (request == null) {
                message = "Failed to resolve OpenIdContext!";
            } else {
                OidcSecurityContext oidcSecurityContext = (OidcSecurityContext)request.getAttribute(OidcSecurityContext.class.getName());
                IDToken idToken = oidcSecurityContext.getIDToken();
                if (idToken == null) {
                    message = " unable to resolve IDToken!";
                } else {
                    System.out.println("  Subject = " + idToken.getSubject());
                    System.out.println("  Access token = " + idToken.getAccessTokenHash());
                    System.out.println("  ID token = " + idToken.toString());
                    System.out.println("  Claims json = " + String.valueOf(idToken.getClaimNames()));
                    System.out.println("=========================================");
                    message = "Imixs-Security-OIDC ==> OK \nUser Principal      ==> " + this.principal.getName() + "\n\nSession details are available on server log";
                }
            }
        }
        catch (Exception e) {
            message = "Failed to resolve OpenIdContext!";
            logger.warning((String)message);
            logger.warning(e.toString());
        }
        return message;
    }

    public void onProfileEvent(@Observes ProfileEvent profileEvent) throws AccessDeniedException {
        int eventType = profileEvent.getEventType();
        ItemCollection profile = profileEvent.getProfile();
        if (profile == null) {
            return;
        }
        if (2 == eventType || 3 == eventType) {
            logger.info("\u251c\u2500\u2500 Processing Wildfly OIDC login...");
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            if (request == null) {
                logger.warning("\u2502   \u251c\u2500\u2500 unable to resolve http request!");
                return;
            }
            OidcSecurityContext oidcSecurityContext = (OidcSecurityContext)request.getAttribute(OidcSecurityContext.class.getName());
            IDToken idToken = oidcSecurityContext.getIDToken();
            if (idToken == null) {
                logger.warning("\u2502   \u251c\u2500\u2500 unable to resolve IDToken!");
                return;
            }
            String userName = idToken.getName();
            String email = idToken.getEmail();
            logger.info("\u2502   \u251c\u2500\u2500 PreferredUsername=" + userName);
            logger.info("\u2502   \u251c\u2500\u2500 Email=" + email);
            if (!email.equals(profile.getItemValueString("txtemail")) || !userName.equals(profile.getItemValueString("txtusername"))) {
                logger.info("\u2502   \u251c\u2500\u2500 update profile data...");
                profile.setItemValue("txtemail", (Object)email);
                profile.setItemValue("txtusername", (Object)userName);
            } else {
                logger.info("\u2502   \u251c\u2500\u2500 profile already up-to-date.");
            }
        }
    }
}

