/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.oidc;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;

@RequestScoped
@Path(value="/oidc")
@Produces(value={"text/plain"})
@OpenIdAuthenticationMechanismDefinition(clientId="${oidcConfig.clientId}", clientSecret="${oidcConfig.clientSecret}", redirectURI="${baseURL}/callback", providerURI="${oidcConfig.issuerUri}")
public class Securitybean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Securitybean.class.getName());
    @Inject
    Principal principal;
    @Inject
    private OpenIdContext context;

    @GET
    @Produces(value={"text/plain"})
    public String sessionInfoAuth() {
        Object message = "";
        try {
            logger.info("Imixs-Security-OIDC - collecting context information... (see details in server log)");
            System.out.println("=========================================");
            if (this.principal != null) {
                System.out.println("  Principal name: " + this.principal.getName());
            } else {
                System.out.println("  Principal resolved to null!");
            }
            if (this.context == null) {
                message = "Failed to resolve OpenIdContext!";
            } else {
                System.out.println("  Subject = " + this.context.getSubject());
                System.out.println("  Access token = " + String.valueOf(this.context.getAccessToken()));
                System.out.println("  ID token = " + String.valueOf(this.context.getIdentityToken()));
                System.out.println("  Claims json = " + String.valueOf(this.context.getClaimsJson()));
                System.out.println("=========================================");
                message = "Imixs-Security-OIDC ==> OK \nUser Principal      ==> " + this.principal.getName() + "\n\nSession details are available on server log";
            }
        }
        catch (Exception e) {
            message = "Failed to resolve OpenIdContext!";
            logger.warning((String)message);
            logger.warning(e.toString());
        }
        return message;
    }

    public void onProfileEvent(@Observes ProfileEvent profileEvent) throws AccessDeniedException {
        int eventType = profileEvent.getEventType();
        ItemCollection profile = profileEvent.getProfile();
        if (profile == null) {
            return;
        }
        if (this.context != null && (2 == eventType || 3 == eventType)) {
            AccessToken accessToken = this.context.getAccessToken();
            String userName = String.valueOf(accessToken.getClaim("name"));
            String email = String.valueOf(accessToken.getClaim("email"));
            if (!email.equals(profile.getItemValueString("txtemail")) || !userName.equals(profile.getItemValueString("txtusername"))) {
                logger.info("...update profile data...");
                profile.setItemValue("txtemail", (Object)email);
                profile.setItemValue("txtusername", (Object)userName);
            }
        }
    }
}

