/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.office.forms.CustomFormItem;
import org.imixs.workflow.office.forms.CustomFormSection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Named
@ConversationScoped
public class CustomFormController
implements Serializable {
    public static final String DEFAULT_EDITOR_ID = "form_panel_simple#basic";
    @EJB
    ModelService modelService;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CustomFormController.class.getName());
    private List<CustomFormSection> sections;

    public List<CustomFormSection> getSections() {
        return this.sections;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null) {
            return;
        }
        if (workflowEvent.getWorkitem() != null && !workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if (21 == eventType || 20 == eventType || 23 == eventType) {
            this.computeFieldDefinition(workflowEvent.getWorkitem());
        }
    }

    public void computeFieldDefinition(ItemCollection workitem) {
        this.sections = new ArrayList<CustomFormSection>();
        String content = this.fetchFormDefinitionFromModel(workitem);
        if (content.isEmpty()) {
            content = workitem.getItemValueString("txtWorkflowEditorCustomForm");
        }
        if (!content.isEmpty()) {
            logger.finest("......start parsing custom form definition");
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
                Document doc = builder.parse(stream);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("imixs-form-section");
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Node nNode = nList.item(temp);
                    logger.finest("parsing section...");
                    if (nNode.getNodeType() != 1) continue;
                    Element eElement = (Element)nNode;
                    CustomFormSection customSection = new CustomFormSection(eElement.getAttribute("label"), eElement.getAttribute("columns"));
                    customSection.setItems(this.findItems(eElement));
                    this.sections.add(customSection);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.warning("Unable to parse custom form definition: " + e.getMessage());
                return;
            }
            workitem.replaceItemValue("txtWorkflowEditorCustomForm", (Object)content);
        }
    }

    private String fetchFormDefinitionFromModel(ItemCollection workitem) {
        ItemCollection task;
        try {
            Model model = this.modelService.getModelByWorkitem(workitem);
            task = model.getTask(workitem.getTaskID());
        }
        catch (ModelException e) {
            logger.warning("unable to parse data object in model: " + e.getMessage());
            return "";
        }
        List dataObjects = task.getItemValue("dataObjects");
        if (dataObjects.size() > 0) {
            List firstDataObject = (List)dataObjects.get(0);
            String templateName = (String)firstDataObject.get(0);
            String content = (String)firstDataObject.get(1);
            logger.finest("......DataObject name=" + templateName);
            logger.finest("......DataObject content=" + content);
            return content;
        }
        return "";
    }

    private List<CustomFormItem> findItems(Element sectionElement) {
        ArrayList<CustomFormItem> result = new ArrayList<CustomFormItem>();
        NodeList itemList = sectionElement.getElementsByTagName("item");
        for (int temp = 0; temp < itemList.getLength(); ++temp) {
            Node itemNode = itemList.item(temp);
            logger.finest("......parsing item...");
            if (itemNode.getNodeType() != 1) continue;
            Element itemElement = (Element)itemNode;
            CustomFormItem customItem = new CustomFormItem(itemElement.getAttribute("name"), itemElement.getAttribute("type"), itemElement.getAttribute("label"), Boolean.parseBoolean(itemElement.getAttribute("required")), itemElement.getAttribute("options"));
            result.add(customItem);
        }
        return result;
    }
}

