/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.imixs.workflow.faces.data.WorkflowController;

@Named
@RequestScoped
public class IbanBicController
implements Serializable {
    public static final String IBAN_PATTERN = "^$|(^[A-Z]{2}(?:[ ]?[A-Z0-9]){13,32}$)";
    public static final String BIC_PATTERN = "^$|(^([a-zA-Z]{4}[a-zA-Z]{2}[a-zA-Z0-9]{2}([a-zA-Z0-9]{3})?))";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(IbanBicController.class.getName());
    @Inject
    WorkflowController workflowController;

    @Valid
    @Pattern(regexp="^$|(^([a-zA-Z]{4}[a-zA-Z]{2}[a-zA-Z0-9]{2}([a-zA-Z0-9]{3})?))")
    public @Valid @Pattern(regexp="^$|(^([a-zA-Z]{4}[a-zA-Z]{2}[a-zA-Z0-9]{2}([a-zA-Z0-9]{3})?))") String getBic() {
        logger.finest("......validate _cdtr_bic...");
        return this.workflowController.getWorkitem().getItemValueString("_bic");
    }

    public void setBic(String bic) {
        this.workflowController.getWorkitem().setItemValue("_bic", (Object)bic);
    }

    @Valid
    @Pattern(regexp="^$|(^[A-Z]{2}(?:[ ]?[A-Z0-9]){13,32}$)")
    public @Valid @Pattern(regexp="^$|(^[A-Z]{2}(?:[ ]?[A-Z0-9]){13,32}$)") String getIban() {
        logger.finest("......validate _cdtr_iban...");
        return this.workflowController.getWorkitem().getItemValueString("_iban");
    }

    public void setIban(String iban) {
        this.workflowController.getWorkitem().setItemValue("_iban", (Object)iban);
    }
}

