/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.office.forms.FormController;
import org.imixs.workflow.office.forms.FormDefinition;

@Named
@ConversationScoped
public class MinuteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    Event<WorkflowEvent> events;
    private List<ItemCollection> minutes = null;
    private ItemCollection workitem = null;
    private ItemCollection parentWorkitem = null;
    private static Logger logger = Logger.getLogger(MinuteController.class.getName());
    protected FormController formController = new FormController();
    private FormDefinition formDefinition = null;
    @EJB
    DocumentService documentService;
    @EJB
    WorkflowService workflowService;

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws AccessDeniedException {
        if (workflowEvent == null || workflowEvent.getWorkitem() == null) {
            return;
        }
        if (workflowEvent.getWorkitem() != null && !workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        int eventType = workflowEvent.getEventType();
        if ("minuteparent".equals(workflowEvent.getWorkitem().getItemValueString("minutetype")) && 21 == eventType) {
            this.minutes = null;
            this.parentWorkitem = workflowEvent.getWorkitem();
        }
    }

    public FormDefinition getFormDefinition() {
        return this.formDefinition;
    }

    public void reset() {
        this.workitem = null;
        this.minutes = null;
    }

    public void toggleWorkitem(String id) {
        if (this.getWorkitem().getUniqueID().equals(id)) {
            this.setWorkitem(null);
        } else {
            this.setWorkitem(this.documentService.load(id));
        }
    }

    public void setWorkitem(ItemCollection workitem) {
        this.workitem = workitem;
        this.formDefinition = this.formController.computeFormDefinition(workitem);
    }

    public ItemCollection getWorkitem() {
        if (this.workitem == null) {
            this.workitem = new ItemCollection();
        }
        return this.workitem;
    }

    public List<ItemCollection> getMinutes() {
        if (this.minutes == null) {
            this.minutes = this.loadMinutes();
        }
        return this.minutes;
    }

    public void process(int eventID) {
        try {
            if (this.workitem != null) {
                this.workitem.setEventID(eventID);
                long l1 = System.currentTimeMillis();
                this.events.fire((Object)new WorkflowEvent(this.getWorkitem(), 22));
                logger.finest("......fire WORKITEM_BEFORE_PROCESS event: ' in " + (System.currentTimeMillis() - l1) + "ms");
                this.workflowService.processWorkItem(this.workitem);
            }
        }
        catch (ModelException | PluginException e) {
            logger.warning("failed to process minute item: " + e.getMessage());
        }
        this.reset();
    }

    public List<ItemCollection> getEvents() {
        List<Object> activityList = new ArrayList<ItemCollection>();
        if (this.workitem == null) {
            return activityList;
        }
        try {
            activityList = this.workflowService.getEvents(this.workitem);
        }
        catch (ModelException e) {
            logger.warning("Unable to get workflow event list: " + e.getMessage());
        }
        return activityList;
    }

    List<ItemCollection> loadMinutes() {
        String uniqueIdRef;
        logger.fine("load minute list...");
        List<Object> minutes = new ArrayList<ItemCollection>();
        if (this.parentWorkitem != null && !(uniqueIdRef = this.parentWorkitem.getItemValueString("$uniqueid")).isEmpty()) {
            String sQuery = null;
            sQuery = "( (type:\"workitem\" OR type:\"childworkitem\" OR type:\"workitemarchive\" OR type:\"childworkitemarchive\") ";
            sQuery = sQuery + " AND ($uniqueidref:\"" + uniqueIdRef + "\")) ";
            try {
                minutes = this.documentService.find(sQuery, 999, 0);
                Collections.sort(minutes, new ItemCollectionComparator("numsequencenumber", true));
            }
            catch (QueryException e) {
                logger.warning("loadWorkitems - invalid query: " + e.getMessage());
            }
        }
        for (int i = minutes.size(); i > 0; --i) {
            ItemCollection minute = (ItemCollection)minutes.get(i - 1);
            String testSubject = minute.getItemValueString("action");
            if (!testSubject.equalsIgnoreCase("open")) continue;
            this.setWorkitem(minute);
            break;
        }
        return minutes;
    }
}

