/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.faces.event.AjaxBehaviorEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.faces.data.WorkflowController;

@Named
@SessionScoped
public class SuggestInputController
implements Serializable {
    public static final int MAX_RESULT = 30;
    static Logger logger = Logger.getLogger(SuggestInputController.class.getName());
    @EJB
    DocumentService documentService = null;
    @EJB
    SchemaService schemaService;
    @Inject
    protected WorkflowController workflowController;
    private static final long serialVersionUID = 1L;
    private List<ItemCollection> searchResult = null;

    public List<ItemCollection> getSearchResult() {
        return this.searchResult;
    }

    public void reset() {
        this.searchResult = new ArrayList<ItemCollection>();
        logger.fine("reset");
    }

    public void reset(AjaxBehaviorEvent event) {
        this.reset();
    }

    public void update(ItemCollection workitem, ItemCollection suggest, String itemList) {
        String[] itemNames;
        logger.finest("......update " + itemList + "...");
        for (String itemName : itemNames = itemList.split("[\\s,;]+")) {
            logger.finest("......update item " + itemName);
            workitem.replaceItemValue(itemName, (Object)suggest.getItemValue(itemName));
            logger.finest("......new value=" + suggest.getItemValue(itemName));
        }
    }

    public void search(String keyItemName, String input, String searchItemList, String workflowGroup) {
        this.search(keyItemName, input, searchItemList, workflowGroup, null);
    }

    public void search(String keyItemName, String input, String searchItemList, String workflowGroup, String query) {
        if (input == null || input.length() < 3) {
            return;
        }
        logger.finest("......search for=" + input);
        this.searchResult = this.searchEntity(keyItemName, searchItemList, workflowGroup, input, query);
    }

    private List<ItemCollection> searchEntity(String keyItemName, String searccItemList, String workflowGroup, String phrase, String _query) {
        long l = System.currentTimeMillis();
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        Collection col = null;
        try {
            String currentID;
            phrase = phrase.trim();
            phrase = this.schemaService.normalizeSearchTerm(phrase);
            String sQuery = null;
            if (_query != null && !_query.isEmpty()) {
                sQuery = _query;
                sQuery = sQuery.replace("'", "\"");
            } else {
                sQuery = "(type:\"workitem\" OR type:\"workitemarchive\")";
                if (workflowGroup != null && !workflowGroup.isEmpty()) {
                    sQuery = sQuery + " AND ($workflowgroup:\"" + workflowGroup + "\")";
                }
            }
            if (this.workflowController.getWorkitem() != null && !(currentID = this.workflowController.getWorkitem().getUniqueID()).isEmpty()) {
                sQuery = sQuery + " AND NOT($uniqueid:" + currentID + ") ";
            }
            String[] itemNames = searccItemList.split("[\\s,;]+");
            sQuery = sQuery + " AND (";
            for (String itemName : itemNames) {
                sQuery = sQuery + "(" + itemName + ":(" + phrase + "*)) OR ";
            }
            sQuery = sQuery.substring(0, sQuery.length() - 3);
            sQuery = sQuery + ")";
            logger.finest("......search: " + sQuery);
            col = this.documentService.find(sQuery, 30, 0, "$modified", true);
            logger.finest("......found: " + col.size());
        }
        catch (Exception e) {
            logger.warning("  lucene error - " + e.getMessage());
        }
        long l1 = System.currentTimeMillis();
        Set uniqueResultList = col.stream().collect(Collectors.toCollection(() -> new TreeSet<ItemCollection>(new SuggestItemCollectionComparator(keyItemName))));
        logger.finest("...filtert result list in " + (System.currentTimeMillis() - l1) + "ms");
        searchResult.addAll(uniqueResultList);
        Collections.sort(searchResult, new ItemCollectionComparator(keyItemName, true));
        logger.info("...computed suggestion result in " + (System.currentTimeMillis() - l) + "ms");
        return searchResult;
    }

    class SuggestItemCollectionComparator
    implements Comparator<ItemCollection> {
        String itemName;

        public SuggestItemCollectionComparator(String aItemName) {
            this.itemName = aItemName;
        }

        @Override
        public int compare(ItemCollection e1, ItemCollection e2) {
            return e1.getItemValueString(this.itemName).compareTo(e2.getItemValueString(this.itemName));
        }
    }
}

