/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.plugins.gdpr;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;

public class GDPRPlugin
extends AbstractPlugin {
    private static Logger logger = Logger.getLogger(GDPRPlugin.class.getName());
    public static String PROCESSING_ERROR = "PROCESSING_ERROR";

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(documentActivity, documentContext);
        if (evalItemCollection != null && evalItemCollection.hasItem("gdpr")) {
            String processDefinition = evalItemCollection.getItemValueString("gdpr");
            ItemCollection processingData = XMLParser.parseItemStructure((String)processDefinition);
            if ("create".equalsIgnoreCase(processingData.getItemValueString("mode"))) {
                this.createGdprSubTasks(documentContext, processingData);
            }
            if ("update".equalsIgnoreCase(processingData.getItemValueString("mode"))) {
                this.updateGdprSubTasks(documentContext, processingData);
            }
        }
        if (documentContext.hasItem("_affected_systems")) {
            String saffectedSystems = documentContext.getItemValueString("_affected_systems");
            String[] list = saffectedSystems.split(",");
            ArrayList<String> newList = new ArrayList<String>();
            for (String id : list) {
                newList.add(id);
            }
            documentContext.replaceItemValue("$workitemref", newList);
        }
        return documentContext;
    }

    private void createGdprSubTasks(ItemCollection workItem, ItemCollection processingData) throws PluginException {
        logger.finest("......creating gdpr sub tasks...");
        int processID = processingData.getItemValueInteger("processid");
        int activityID = processingData.getItemValueInteger("activityid");
        List<ItemCollection> systems = this.findActiveSystems();
        if (systems != null) {
            for (ItemCollection system : systems) {
                ItemCollection subWorkitem = new ItemCollection();
                subWorkitem.replaceItemValue("$modelversion", (Object)workItem.getModelVersion());
                subWorkitem.replaceItemValue("$taskid", (Object)processID);
                subWorkitem.setEventID(activityID);
                subWorkitem.replaceItemValue("$uniqueidref", (Object)workItem.getUniqueID());
                subWorkitem.replaceItemValue("txtprocessref", (Object)workItem.getItemValueString("txtprocessRef"));
                subWorkitem.replaceItemValue("txtspaceref", (Object)system.getUniqueID());
                subWorkitem.replaceItemValue("_gdpr_parent_uniqueid", (Object)workItem.getUniqueID());
                subWorkitem.replaceItemValue("$workitemref", (Object)workItem.getUniqueID());
                this.copyItemList(processingData.getItemValueString("items"), workItem, subWorkitem);
                subWorkitem.replaceItemValue("_system_subject", (Object)system.getItemValueString("_subject"));
                subWorkitem.replaceItemValue("namteam", (Object)system.getItemValueString("namteam"));
                try {
                    this.getWorkflowService().processWorkItem(subWorkitem);
                }
                catch (AccessDeniedException | ModelException | ProcessingErrorException e) {
                    throw new PluginException(GDPRPlugin.class.getName(), PROCESSING_ERROR, e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private void updateGdprSubTasks(ItemCollection workItem, ItemCollection processingData) throws PluginException {
        logger.finest("......updateing gdpr sub tasks...");
        int processID = processingData.getItemValueInteger("processid");
        int activityID = processingData.getItemValueInteger("activityid");
        List<ItemCollection> subTasks = this.findSubTasks(workItem.getItemValueString("$uniqueidref"));
        for (ItemCollection subtask : subTasks) {
            if (processID != subtask.getTaskID()) continue;
            subtask.setEventID(activityID);
            this.copyItemList(processingData.getItemValueString("items"), workItem, subtask);
            try {
                this.getWorkflowService().processWorkItem(subtask);
            }
            catch (AccessDeniedException | ModelException | ProcessingErrorException e) {
                throw new PluginException(GDPRPlugin.class.getName(), PROCESSING_ERROR, e.getMessage(), (Exception)e);
            }
        }
    }

    private List<ItemCollection> findActiveSystems() {
        List systemList;
        String sQuery = "(type:\"workitem\" AND $processid:[1100 TO 1899] )";
        try {
            systemList = this.getWorkflowService().getDocumentService().find(sQuery, 999, 0);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        return systemList;
    }

    private List<ItemCollection> findSubTasks(String parentRef) {
        List systemList;
        String sQuery = "(type:\"workitem\" AND $uniqueidref:\"" + parentRef + "\")";
        try {
            systemList = this.getWorkflowService().getDocumentService().find(sQuery, 999, 0);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        return systemList;
    }

    private void copyItemList(String items, ItemCollection source, ItemCollection target) {
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            int pos = field.indexOf(124);
            if (pos > -1) {
                target.replaceItemValue(field.substring(pos + 1).trim(), (Object)source.getItemValue(field.substring(0, pos).trim()));
                continue;
            }
            target.replaceItemValue(field, (Object)source.getItemValue(field));
        }
    }
}

