/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.config.SetupController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.office.views.BoardCategory;
import org.imixs.workflow.office.views.SearchController;

@Named
@ViewScoped
public class BoardController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final int DEFAULT_CATEGORY_PAGE_SIZE = 5;
    private Map<BoardCategory, List<ItemCollection>> cacheTasks;
    private int categoryPageSize;
    private int pageIndex = 0;
    private boolean endOfList = false;
    private String query;
    private String title;
    @Inject
    protected LoginController loginController = null;
    @Inject
    SetupController setupController;
    private static Logger logger = Logger.getLogger(BoardController.class.getName());
    @EJB
    ModelService modelService = null;
    @EJB
    DocumentService documentService;
    @EJB
    SchemaService schemaService;
    @Inject
    SearchController searchController;
    @Inject
    @ConfigProperty(name="boardcontroller.pagesize", defaultValue="100")
    int pageSize;

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageSize() {
        if (this.pageSize <= 0) {
            this.pageSize = 100;
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getRef() {
        return this.searchController.getSearchFilter().getItemValueString("processref");
    }

    public void setRef(String ref) {
        ItemCollection process;
        this.searchController.getSearchFilter().setItemValue("processref", (Object)ref);
        if (ref != null && !ref.isEmpty() && (process = this.documentService.load(ref)) != null) {
            String title = process.getItemValueString("name");
            this.setTitle(title);
        }
    }

    public String getPhrase() {
        return this.searchController.getSearchFilter().getItemValueString("phrase");
    }

    public void setPhrase(String phrase) {
        this.searchController.getSearchFilter().setItemValue("phrase", (Object)phrase);
    }

    public String getTitle() {
        if (this.title == null || this.title.isEmpty()) {
            try {
                Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                ResourceBundle rb = null;
                rb = locale != null ? ResourceBundle.getBundle("bundle.messages", locale) : ResourceBundle.getBundle("bundle.messages");
                this.title = rb.getString("worklist.owner");
            }
            catch (MissingResourceException eb) {
                this.title = "";
            }
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getQuery() {
        this.query = this.getRef().isEmpty() ? "(type:\"workitem\" AND $owner:\"" + this.loginController.getRemoteUser() + "\")" : "(type:\"workitem\" AND $uniqueidref:\"" + this.getRef() + "\")";
        String searchphrase = this.getPhrase();
        if (searchphrase != null && !searchphrase.isEmpty() && (searchphrase = this.schemaService.normalizeSearchTerm(searchphrase)) != null && !"".equals(searchphrase)) {
            searchphrase = searchphrase.trim();
            searchphrase = searchphrase.toLowerCase();
            this.query = this.query + " AND (" + searchphrase + ") ";
        }
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void reset() {
        this.cacheTasks = null;
        this.pageIndex = 0;
        this.endOfList = false;
    }

    public void refresh() {
        this.cacheTasks = null;
        this.pageIndex = 0;
        this.endOfList = false;
    }

    public List<BoardCategory> getCategories() {
        if (this.cacheTasks == null) {
            this.readWorkList();
        }
        ArrayList<BoardCategory> result = new ArrayList<BoardCategory>();
        result.addAll(this.cacheTasks.keySet());
        Collections.sort(result, new Comparator<BoardCategory>(){

            @Override
            public int compare(BoardCategory p1, BoardCategory p2) {
                return p1.toString().compareTo(p2.toString());
            }
        });
        return result;
    }

    public void doLoadNext() {
        ++this.pageIndex;
        this.cacheTasks = null;
    }

    public void doLoadNext(ActionEvent event) {
        this.doLoadNext();
    }

    public void doLoadNext(AjaxBehaviorEvent event) {
        this.doLoadNext();
    }

    public void doLoadPrev() {
        --this.pageIndex;
        if (this.pageIndex < 0) {
            this.pageIndex = 0;
        }
        this.cacheTasks = null;
    }

    public void doLoadPrev(ActionEvent event) {
        this.doLoadPrev();
    }

    public void doLoadPrev(AjaxBehaviorEvent event) {
        this.doLoadPrev();
    }

    public boolean isEndOfList() {
        if (this.cacheTasks == null) {
            this.readWorkList();
        }
        return this.endOfList;
    }

    public void setEndOfList(boolean endOfList) {
        this.endOfList = endOfList;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null || workflowEvent.getWorkitem() == null) {
            return;
        }
        if (23 == workflowEvent.getEventType()) {
            this.refresh();
        }
    }

    public int getCategoryPageSize() {
        if (this.categoryPageSize <= 0) {
            this.categoryPageSize = 5;
        }
        return this.categoryPageSize;
    }

    public void setCategoryPageSize(int categoryPageSize) {
        this.categoryPageSize = categoryPageSize;
    }

    public List<ItemCollection> getWorkitems(BoardCategory category) {
        List<ItemCollection> temp = this.cacheTasks.get(category);
        int iStart = category.getPageIndex() * category.getPageSize();
        int iEnd = iStart + category.getPageSize();
        if (iEnd > temp.size()) {
            iEnd = temp.size();
        }
        return temp.subList(iStart, iEnd);
    }

    public void doLoadNext(BoardCategory category) {
        if (!this.isEndOfList(category)) {
            category.setPageIndex(category.pageIndex + 1);
        }
    }

    public void doLoadPrev(BoardCategory category) {
        if (category.pageIndex > 0) {
            category.setPageIndex(category.pageIndex - 1);
        }
    }

    public boolean isEndOfList(BoardCategory category) {
        List<ItemCollection> temp = this.cacheTasks.get(category);
        int i = (category.getPageIndex() + 1) * category.getPageSize();
        return i >= temp.size();
    }

    private void readWorkList() {
        ArrayList taskList;
        long l = System.currentTimeMillis();
        this.cacheTasks = new HashMap<BoardCategory, List<ItemCollection>>();
        String sortBy = this.setupController.getSortBy();
        boolean bReverse = this.setupController.getSortReverse();
        try {
            taskList = this.documentService.findStubs(this.getQuery(), this.getPageSize(), this.getPageIndex(), sortBy, bReverse);
        }
        catch (QueryException e) {
            logger.warning("failed to read task list: " + e.getMessage());
            taskList = new ArrayList();
        }
        this.endOfList = taskList.size() < this.pageSize;
        for (ItemCollection workitem : taskList) {
            BoardCategory tmpCat = new BoardCategory(workitem.getItemValueString("$workflowgroup"), workitem.getItemValueString("$workflowstatus"), workitem.getTaskID(), this.getCategoryPageSize());
            List<ItemCollection> tasksByCategory = this.cacheTasks.get(tmpCat);
            if (tasksByCategory == null) {
                tasksByCategory = new ArrayList<ItemCollection>();
            }
            tasksByCategory.add(workitem);
            this.cacheTasks.put(tmpCat, tasksByCategory);
        }
        logger.fine("read worklist in " + (System.currentTimeMillis() - l) + "ms");
    }
}

