/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.marty.config.SetupController;
import org.imixs.marty.model.TeamController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.faces.data.ViewController;
import org.imixs.workflow.faces.util.LoginController;

@Named
@SessionScoped
public class SearchController
extends ViewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(SearchController.class.getName());
    ItemCollection searchFilter = null;
    @Inject
    SetupController setupController;
    @Inject
    TeamController processController;
    @Inject
    LoginController loginController;
    @EJB
    SchemaService schemaService;
    ItemCollection process;
    ItemCollection space;

    public String getSortBy() {
        if ("1".equals(this.getSearchFilter().getItemValueString("sortorder")) || "2".equals(this.getSearchFilter().getItemValueString("sortorder"))) {
            return "$lasteventdate";
        }
        return super.getSortBy();
    }

    public boolean isSortReverse() {
        if ("2".equals(this.getSearchFilter().getItemValueString("sortorder"))) {
            return false;
        }
        if ("1".equals(this.getSearchFilter().getItemValueString("sortorder"))) {
            return true;
        }
        return super.isSortReverse();
    }

    public void init() {
        String phrase;
        FacesContext fc;
        Map paramMap;
        String processRef;
        this.setSortBy(this.setupController.getSortBy());
        this.setSortReverse(this.setupController.getSortReverse());
        if (this.searchFilter == null) {
            this.searchFilter = new ItemCollection();
        }
        if ((processRef = (String)(paramMap = (fc = FacesContext.getCurrentInstance()).getExternalContext().getRequestParameterMap()).get("processref")) != null && !processRef.isEmpty()) {
            this.searchFilter.replaceItemValue("processref", (Object)processRef);
        }
        if ("true".equals(paramMap.get("archive"))) {
            this.searchFilter.replaceItemValue("type", (Object)"workitemarchive");
        } else {
            this.searchFilter.replaceItemValue("type", (Object)"workitem");
        }
        String spaceRef = (String)paramMap.get("spaceref");
        if (spaceRef != null && !spaceRef.isEmpty()) {
            this.searchFilter.replaceItemValue("spaceref", (Object)spaceRef);
        }
        if ((phrase = (String)paramMap.get("phrase")) != null && !phrase.isEmpty()) {
            this.searchFilter.replaceItemValue("phrase", (Object)phrase);
        }
        this.process = this.processController.getEntityById(this.searchFilter.getItemValueString("processref"));
        this.space = this.processController.getEntityById(this.searchFilter.getItemValueString("spaceref"));
    }

    public ItemCollection getProcess() {
        return this.process;
    }

    public ItemCollection getSpace() {
        return this.space;
    }

    public void reset() {
        this.searchFilter = new ItemCollection();
        this.searchFilter.replaceItemValue("type", (Object)"workitem");
        super.reset();
    }

    public void resetFilter() {
        String searchPhrase = this.searchFilter.getItemValueString("txtSearch");
        this.searchFilter = new ItemCollection();
        this.searchFilter.replaceItemValue("type", (Object)"workitem");
        super.reset();
        this.searchFilter.replaceItemValue("txtSearch", (Object)searchPhrase);
    }

    public String doSearch() {
        String action = "/pages/workitems/worklist.xhtml?faces-redirect=true&phrase=" + this.searchFilter.getItemValueString("phrase");
        this.searchFilter = new ItemCollection();
        return action;
    }

    public ItemCollection getSearchFilter() {
        if (this.searchFilter == null) {
            this.searchFilter = new ItemCollection();
        }
        return this.searchFilter;
    }

    public void setSearchFilter(ItemCollection searchFilter) {
        this.searchFilter = searchFilter;
    }

    public void setDMSMode(boolean dms) {
        this.searchFilter.replaceItemValue("dms_search", (Object)dms);
    }

    public String getQuery() {
        Calendar cal;
        String sSearchTerm = "";
        String emptySearchTerm = "";
        List processIDs = this.searchFilter.getItemValue("$taskID");
        List processRefList = this.searchFilter.getItemValue("ProcessRef");
        List spacesRefList = this.searchFilter.getItemValue("SpaceRef");
        List workflowGroups = this.searchFilter.getItemValue("$WorkflowGroup");
        while (processIDs.contains("")) {
            processIDs.remove("");
        }
        while (processRefList.contains("")) {
            processRefList.remove("");
        }
        while (spacesRefList.contains("")) {
            spacesRefList.remove("");
        }
        while (workflowGroups.contains("")) {
            workflowGroups.remove("");
        }
        while (processRefList.contains("-")) {
            processRefList.remove("-");
        }
        while (spacesRefList.contains("-")) {
            spacesRefList.remove("-");
        }
        List<String> typeList = this.searchFilter.getItemValue("Type");
        if (typeList.isEmpty() || "".equals(typeList.get(0))) {
            typeList = Arrays.asList("workitem");
        }
        String sTypeQuery = "";
        Iterator<String> iterator = typeList.iterator();
        while (iterator.hasNext()) {
            sTypeQuery = sTypeQuery + "type:\"" + iterator.next() + "\"";
            if (!iterator.hasNext()) continue;
            sTypeQuery = sTypeQuery + " OR ";
        }
        emptySearchTerm = sSearchTerm = sSearchTerm + "(" + sTypeQuery + ") AND";
        if ("true".equals(this.searchFilter.getItemValueString("dms_search"))) {
            sSearchTerm = sSearchTerm + " ($file.count:[1 TO 999]) AND";
        }
        String sCreator = "";
        if ("true".equals(this.getSearchFilter().getItemValueString("my_requests"))) {
            sCreator = this.loginController.getUserPrincipal();
        }
        Date datFrom = this.searchFilter.getItemValueDate("date.From");
        Date datTo = this.searchFilter.getItemValueDate("date.To");
        if (!processRefList.isEmpty()) {
            sSearchTerm = sSearchTerm + " (";
            iterator = processRefList.iterator();
            while (iterator.hasNext()) {
                sSearchTerm = sSearchTerm + "$uniqueidref:\"" + iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                sSearchTerm = sSearchTerm + " OR ";
            }
            sSearchTerm = sSearchTerm + " ) AND";
        }
        if (!spacesRefList.isEmpty()) {
            sSearchTerm = sSearchTerm + " (";
            iterator = spacesRefList.iterator();
            while (iterator.hasNext()) {
                sSearchTerm = sSearchTerm + "$uniqueidref:\"" + iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                sSearchTerm = sSearchTerm + " OR ";
            }
            sSearchTerm = sSearchTerm + " ) AND";
        }
        if (!workflowGroups.isEmpty()) {
            sSearchTerm = sSearchTerm + " (";
            iterator = workflowGroups.iterator();
            while (iterator.hasNext()) {
                sSearchTerm = sSearchTerm + "txtworkflowgroup:\"" + iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                sSearchTerm = sSearchTerm + " OR ";
            }
            sSearchTerm = sSearchTerm + " ) AND";
        }
        String sDateFrom = "191401070000";
        String sDateTo = "211401070000";
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmm");
        if (datFrom != null) {
            cal = Calendar.getInstance();
            cal.setTime(datFrom);
            sDateFrom = dateformat.format(cal.getTime());
        }
        if (datTo != null) {
            cal = Calendar.getInstance();
            cal.setTime(datTo);
            cal.add(5, 1);
            sDateTo = dateformat.format(cal.getTime());
        }
        if (datFrom != null || datTo != null) {
            sSearchTerm = sSearchTerm + " ($created:[" + sDateFrom + " TO " + sDateTo + "]) AND";
        }
        if (!"".equals(sCreator)) {
            sSearchTerm = sSearchTerm + " ($creator:\"" + sCreator.toLowerCase() + "\" OR $owner:\"" + sCreator.toLowerCase() + "\") AND";
        }
        if (!processIDs.isEmpty()) {
            sSearchTerm = sSearchTerm + " (";
            Iterator iteratorID = processIDs.iterator();
            while (iteratorID.hasNext()) {
                sSearchTerm = sSearchTerm + "$taskid:\"" + iteratorID.next() + "\"";
                if (!iteratorID.hasNext()) continue;
                sSearchTerm = sSearchTerm + " OR ";
            }
            sSearchTerm = sSearchTerm + " ) AND";
        }
        String searchphrase = this.searchFilter.getItemValueString("phrase");
        if ((searchphrase = this.schemaService.normalizeSearchTerm(searchphrase)) != null && !"".equals(searchphrase)) {
            this.setSortBy(null);
            this.setSortReverse(false);
            searchphrase = searchphrase.trim();
            searchphrase = searchphrase.toLowerCase();
            sSearchTerm = sSearchTerm + " (" + searchphrase + ") ";
        } else {
            this.setSortBy(this.setupController.getSortBy());
            this.setSortReverse(this.setupController.getSortReverse());
        }
        if (sSearchTerm.equals(emptySearchTerm)) {
            sSearchTerm = null;
        }
        if (sSearchTerm != null && sSearchTerm.endsWith("AND")) {
            sSearchTerm = sSearchTerm.substring(0, sSearchTerm.length() - 3);
        }
        logger.fine("Query=" + sSearchTerm);
        return sSearchTerm;
    }
}

