/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.faces.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.marty.util.WorkitemHelper;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@SessionScoped
public class HistoryController
implements Serializable {
    @Inject
    protected WorkflowController workflowController;
    @EJB
    protected DocumentService documentService;
    private static final long serialVersionUID = 1L;
    private List<ItemCollection> workitems = new ArrayList<ItemCollection>();
    private String currentId = null;

    public String getCurrentId() {
        return this.currentId;
    }

    public void setCurrentId(String currentId) {
        this.currentId = currentId;
    }

    public List<ItemCollection> getWorkitems() {
        if (this.workitems == null) {
            this.workitems = new ArrayList<ItemCollection>();
        }
        return this.workitems;
    }

    public String removeWorkitem(String aID) {
        int iPos = this.findWorkItem(aID);
        if (iPos > -1) {
            this.workitems.remove(iPos);
            if (aID.equals(this.currentId)) {
                this.currentId = null;
                if (iPos >= this.workitems.size()) {
                    --iPos;
                }
                if (iPos >= 0) {
                    ItemCollection current = this.workitems.get(iPos);
                    if (current != null) {
                        this.currentId = current.getUniqueID();
                        this.workflowController.setWorkitem(this.documentService.load(this.currentId));
                    } else {
                        this.workflowController.setWorkitem(null);
                    }
                } else {
                    this.workflowController.setWorkitem(null);
                }
            }
        }
        return this.currentId == null ? "home" : "/pages/workitems/workitem?id=" + this.currentId + "&faces-redirect=true";
    }

    public void closeCurrentWorkitem(ActionEvent event) {
        int iPos = this.findWorkItem(this.currentId);
        if (iPos > -1) {
            this.workitems.remove(iPos);
        }
        this.currentId = null;
        this.workflowController.close();
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null || workflowEvent.getWorkitem() == null) {
            this.currentId = null;
            return;
        }
        if (!workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        if (21 == workflowEvent.getEventType()) {
            this.addWorkItem(workflowEvent.getWorkitem());
        }
        if (23 == workflowEvent.getEventType()) {
            String result = workflowEvent.getWorkitem().getItemValueString("action");
            if ("home".equals(result) || "notes".equals(result)) {
                this.removeWorkitem(workflowEvent.getWorkitem().getItemValueString("$uniqueid"));
                this.setCurrentId("");
            } else {
                this.addWorkItem(workflowEvent.getWorkitem());
            }
        }
    }

    private void addWorkItem(ItemCollection aWorkitem) {
        if (aWorkitem == null || !aWorkitem.getItemValueString("type").startsWith("workitem") || aWorkitem.getUniqueID().isEmpty()) {
            this.currentId = null;
            return;
        }
        ItemCollection clone = WorkitemHelper.clone((ItemCollection)aWorkitem);
        int iPos = this.findWorkItem(aWorkitem.getUniqueID());
        if (iPos > -1) {
            this.workitems.set(iPos, clone);
        } else {
            this.workitems.add(clone);
        }
        this.currentId = clone.getUniqueID();
    }

    private int findWorkItem(String aID) {
        if (aID == null) {
            return -1;
        }
        for (int i = 0; i < this.workitems.size(); ++i) {
            ItemCollection historyWorkitem = this.workitems.get(i);
            String sHistoryUnqiueID = historyWorkitem.getUniqueID();
            if (!sHistoryUnqiueID.equals(aID)) continue;
            return i;
        }
        return -1;
    }
}

