/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.forms;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.imixs.marty.model.ModelController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.LoginController;

@Deprecated
@Named
@ConversationScoped
public class TimesheetController
implements Serializable {
    @Inject
    private Conversation conversation;
    @Inject
    protected ModelController modelController;
    @Inject
    protected WorkflowController workflowController;
    @EJB
    WorkflowService workflowService;
    public static Logger logger = Logger.getLogger(TimesheetController.class.getName());
    private List<ItemCollection> childList = null;
    private int sortOrder = 1;
    private static final long serialVersionUID = 1L;
    private ItemCollection filter = null;
    private List<ItemCollection> myTimeSheet = null;
    private ItemCollection myTimeSheetSummary = null;
    private ItemCollection filterTimeSheetSummary = null;
    private List<ItemCollection> filterTimeSheet = null;
    private List<ItemCollection> processSelection = null;
    private ItemCollection workitem;
    @Inject
    protected LoginController loginController = null;
    @EJB
    ModelService modelService = null;
    @EJB
    DocumentService documentService;

    public void initFilter() {
        this.filter = new ItemCollection();
        try {
            this.filter.replaceItemValue("datfrom", (Object)new Date());
            this.filter.replaceItemValue("datto", (Object)new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ItemCollection getFilter() {
        if (this.filter == null) {
            this.initFilter();
        }
        return this.filter;
    }

    public void setFilter(ItemCollection filter) {
        this.filter = filter;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ItemCollection getParentWorkitem() {
        return this.workflowController.getWorkitem();
    }

    public String process() throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        String result = this.workflowController.process();
        return result;
    }

    public ItemCollection getWorkitem() {
        if (this.workitem == null) {
            this.workitem = new ItemCollection();
        }
        return this.workitem;
    }

    public void setWorkitem(ItemCollection workitem) {
        this.workitem = workitem;
    }

    public void reset() {
        this.myTimeSheet = null;
        this.filterTimeSheet = null;
    }

    public void clear() {
    }

    public List<ItemCollection> getMyTimeSheet() {
        if (this.myTimeSheet == null) {
            this.loadMyTimeSheet();
        }
        return this.myTimeSheet;
    }

    public ItemCollection getMyTimeSheetSummary() {
        if (this.myTimeSheetSummary == null) {
            this.myTimeSheetSummary = new ItemCollection();
        }
        return this.myTimeSheetSummary;
    }

    public List<ItemCollection> getFilterTimeSheet() {
        if (this.filterTimeSheet == null) {
            this.loadFilterTimeSheet();
        }
        return this.filterTimeSheet;
    }

    public ItemCollection getFilterTimeSheetSummary() {
        if (this.filterTimeSheetSummary == null) {
            this.filterTimeSheetSummary = new ItemCollection();
        }
        return this.filterTimeSheetSummary;
    }

    public List<ItemCollection> getProcessSelection() {
        if (this.processSelection != null) {
            return this.processSelection;
        }
        this.processSelection = new ArrayList<ItemCollection>();
        try {
            String sModelVersion = this.getParentWorkitem().getItemValueString("$modelversion");
            ItemCollection startProcess = this.modelService.getModel(sModelVersion).getTask(6100);
            if (startProcess == null) {
                logger.warning("TimeSheetMB unable to find start ProcessEntity - ID=6100 !");
                return this.processSelection;
            }
            String sWorkflowGroup = startProcess.getItemValueString("txtWorkflowGroup");
            List processList = this.modelService.getModel(sModelVersion).findTasksByGroup(sWorkflowGroup);
            for (ItemCollection process : processList) {
                this.processSelection.add(process);
            }
        }
        catch (Exception e) {
            logger.severe("TimeSheetMB unable - error computing process list");
            e.printStackTrace();
        }
        return this.processSelection;
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws AccessDeniedException {
        if (workflowEvent == null) {
            return;
        }
        if (workflowEvent.getWorkitem() != null && !workflowEvent.getWorkitem().getItemValueString("type").startsWith("workitem")) {
            return;
        }
        if (21 == workflowEvent.getEventType()) {
            this.reset();
            if (this.conversation.isTransient()) {
                this.conversation.setTimeout((long)(((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getSession().getMaxInactiveInterval() * 1000));
                this.conversation.begin();
                logger.fine("start new conversation, id=" + this.conversation.getId());
            }
        }
        if (workflowEvent != null && 21 == workflowEvent.getEventType()) {
            this.initFilter();
        }
    }

    private void loadMyTimeSheet() {
        this.myTimeSheet = new ArrayList<ItemCollection>();
        this.myTimeSheetSummary = new ItemCollection();
        if (this.getParentWorkitem() != null) {
            String uniqueIdRef = this.getParentWorkitem().getItemValueString("$uniqueid");
            String sUser = this.loginController.getUserPrincipal();
            String sQuery = "(type:\"childworkitem\") AND ($uniqueidref:\"" + uniqueIdRef + "\") AND (namcreator:\"" + sUser + "\") AND ($processid:[6100 TO 6999])";
            logger.fine("TimeSheetMB loadMyTimeSheet - query=" + sQuery);
            try {
                List col = this.documentService.find(sQuery, 999, 0, "datdate", true);
                for (ItemCollection aworkitem : col) {
                    this.myTimeSheet.add(this.cloneWorkitem(aworkitem));
                    this.computeSummaryOfNumberValues(aworkitem, this.myTimeSheetSummary);
                }
            }
            catch (QueryException e) {
                logger.warning("loadMyTimeSheet - invalid query: " + e.getMessage());
            }
        }
    }

    private void loadFilterTimeSheet() {
        this.filterTimeSheet = new ArrayList<ItemCollection>();
        this.filterTimeSheetSummary = new ItemCollection();
        if (this.filter == null) {
            return;
        }
        if (this.getParentWorkitem() != null) {
            Date datTo;
            String uniqueIdRef = this.getParentWorkitem().getItemValueString("$uniqueid");
            String sUser = this.filter.getItemValueString("namCreator");
            Date datFrom = this.filter.getItemValueDate("datFrom");
            if (datFrom == null) {
                datFrom = new Date();
            }
            if ((datTo = this.filter.getItemValueDate("datTo")) == null) {
                datTo = new Date();
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            int iProcessID = this.filter.getItemValueInteger("$processid");
            String sQuery = "";
            sQuery = sQuery + "(type:\"childworkitem\" OR type:\"childworkitemarchive\")";
            sQuery = sQuery + " AND ($uniqueidref:\"" + uniqueIdRef + "\")";
            if (!"".equals(sUser)) {
                sQuery = sQuery + " AND (namcreator:\"" + sUser + "\")";
            }
            if (iProcessID > 0) {
                sQuery = sQuery + " AND ($processid:" + iProcessID + ")";
            }
            Calendar calTo = Calendar.getInstance();
            calTo.setTime(datTo);
            calTo.add(5, 1);
            sQuery = sQuery + " AND (datdate:[" + formatter.format(datFrom) + " TO " + formatter.format(calTo.getTime()) + "])";
            logger.fine("loadFilterTimeSheet - query=" + sQuery);
            try {
                List col = this.documentService.find(sQuery, 999, 0, "datdate", true);
                for (ItemCollection aworkitem : col) {
                    this.filterTimeSheet.add(this.cloneWorkitem(aworkitem));
                    this.computeSummaryOfNumberValues(aworkitem, this.filterTimeSheetSummary);
                }
            }
            catch (QueryException e) {
                logger.warning("loadFilterTimeSheet - invalid query: " + e.getMessage());
            }
        }
    }

    private void computeSummaryOfNumberValues(ItemCollection aworkitem, ItemCollection summaryWorkitem) {
        for (Object key : aworkitem.getAllItems().keySet()) {
            try {
                List v = aworkitem.getItemValue(key.toString());
                if (v.size() <= 0) continue;
                Object o = v.get(0);
                Double ff = 0.0;
                try {
                    ff = Double.valueOf(o.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ff == 0.0) continue;
                logger.fine("compute summary " + ff);
                double dSummary = summaryWorkitem.getItemValueDouble(key.toString());
                for (Object d : v) {
                    dSummary += Double.valueOf(d.toString()).doubleValue();
                }
                summaryWorkitem.replaceItemValue(key.toString(), (Object)dSummary);
            }
            catch (Exception e) {
                logger.warning("error computing Summary: " + e.getMessage());
            }
        }
    }

    public ItemCollection cloneWorkitem(ItemCollection aWorkitem) {
        ItemCollection clone = aWorkitem;
        clone.replaceItemValue("_duration", (Object)aWorkitem.getItemValue("_duration"));
        clone.replaceItemValue("_subject", (Object)aWorkitem.getItemValue("_subject"));
        clone.replaceItemValue("_category", (Object)aWorkitem.getItemValue("_category"));
        return clone;
    }

    public List<ItemCollection> getWorkitems() {
        if (this.childList == null) {
            this.childList = this.loadWorkitems();
        }
        return this.childList;
    }

    public List<ItemCollection> loadWorkitems() {
        ArrayList<ItemCollection> resultList = new ArrayList<ItemCollection>();
        if (this.getParentWorkitem() != null) {
            String uniqueIdRef = this.getParentWorkitem().getItemValueString("$uniqueid");
            List col = this.workflowService.getWorkListByRef(uniqueIdRef, "workitemchild", 0, -1, null, false);
            for (ItemCollection aWorkitem : col) {
                resultList.add(this.cloneWorkitem(aWorkitem));
            }
        }
        return resultList;
    }
}

