/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.marty.config.SetupController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.office.views.BoardCategory;
import org.imixs.workflow.office.views.SearchController;

@Named
@ViewScoped
public class BoardController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<BoardCategory, List<ItemCollection>> cacheTasks;
    private String processRef;
    private ItemCollection process;
    private int pageIndex = 0;
    private int pageMax = 0;
    private boolean endOfList = false;
    private String view;
    private String title;
    @Inject
    protected LoginController loginController = null;
    @Inject
    SetupController setupController;
    private static Logger logger = Logger.getLogger(BoardController.class.getName());
    @EJB
    ModelService modelService = null;
    @EJB
    DocumentService documentService;
    @EJB
    SchemaService schemaService;
    @Inject
    @ConfigProperty(name="boardcontroller.pagesize", defaultValue="100")
    int pageSize;
    @Inject
    @ConfigProperty(name="boardcontroller.categorysize", defaultValue="5")
    int categoryPageSize;
    @Inject
    SearchController searchController;

    @PostConstruct
    public void init() {
        String _phrase;
        this.searchController.reset();
        FacesContext fc = FacesContext.getCurrentInstance();
        Map paramMap = fc.getExternalContext().getRequestParameterMap();
        this.setProcessRef((String)paramMap.get("processref"));
        String _page = (String)paramMap.get("page");
        if (_page != null && !_page.isEmpty()) {
            this.setPageIndex(Integer.parseInt(_page));
        }
        if ((_phrase = (String)paramMap.get("phrase")) != null && !_phrase.isEmpty()) {
            this.searchController.getSearchFilter().setItemValue("phrase", (Object)_phrase);
        }
        this.cacheTasks = new HashMap<BoardCategory, List<ItemCollection>>();
        this.readWorkList();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageMax() {
        return this.pageMax;
    }

    public String getProcessRef() {
        if (this.processRef == null) {
            this.processRef = "";
        }
        return this.processRef;
    }

    public void setProcessRef(String processRef) {
        this.processRef = processRef;
        if (processRef != null && !processRef.isEmpty()) {
            this.process = this.documentService.load(processRef);
            if (this.process != null) {
                String title = this.process.getItemValueString("name");
                this.setTitle(title);
            }
        }
    }

    public String getView() {
        if (this.view == null || this.view.isEmpty()) {
            this.view = "worklist.owner";
        }
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public ItemCollection getProcess() {
        return this.process;
    }

    public String getTitle() {
        if (this.title == null || this.title.isEmpty()) {
            try {
                Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                ResourceBundle rb = null;
                rb = locale != null ? ResourceBundle.getBundle("bundle.messages", locale) : ResourceBundle.getBundle("bundle.messages");
                this.title = rb.getString(this.getView());
            }
            catch (MissingResourceException eb) {
                this.title = "";
            }
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPhraseEncoded() {
        if (this.searchController.getSearchFilter() == null) {
            return null;
        }
        try {
            return URLEncoder.encode(this.searchController.getSearchFilter().getItemValueString("phrase"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.searchController.getSearchFilter().getItemValueString("phrase");
        }
    }

    public void reset() {
        this.cacheTasks = null;
        this.pageIndex = 0;
        this.endOfList = false;
    }

    public void refresh() {
        this.cacheTasks = null;
        this.pageIndex = 0;
        this.endOfList = false;
    }

    public String refreshSearch() {
        this.setPageIndex(0);
        return this.getBookmark();
    }

    private String getBookmark() {
        String phrase = this.searchController.getSearchFilter().getItemValueString("phrase");
        try {
            phrase = URLEncoder.encode(phrase, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("unable to encode search phrase!");
            e.printStackTrace();
        }
        String action = "/pages/notes_board.xhtml?faces-redirect=true&page=" + this.getPageIndex() + "&processref=" + this.getProcessRef() + "&phrase=" + phrase;
        return action;
    }

    public String getNext() {
        this.setPageIndex(this.getPageIndex() + 1);
        return this.getBookmark();
    }

    public String getPrev() {
        this.setPageIndex(this.getPageIndex() - 1);
        return this.getBookmark();
    }

    public String getPage(int index) {
        this.setPageIndex(index);
        return this.getBookmark();
    }

    public List<BoardCategory> getCategories() {
        ArrayList<BoardCategory> result = new ArrayList<BoardCategory>();
        result.addAll(this.cacheTasks.keySet());
        Collections.sort(result, new Comparator<BoardCategory>(){

            @Override
            public int compare(BoardCategory p1, BoardCategory p2) {
                return p1.toString().compareTo(p2.toString());
            }
        });
        return result;
    }

    public void doLoadNext(BoardCategory category) {
        if (!this.isEndOfList(category)) {
            category.setPageIndex(category.pageIndex + 1);
        }
    }

    public void doLoadPrev(BoardCategory category) {
        if (category.pageIndex > 0) {
            category.setPageIndex(category.pageIndex - 1);
        }
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    public void setEndOfList(boolean endOfList) {
        this.endOfList = endOfList;
    }

    public int getCategoryPageSize() {
        return this.categoryPageSize;
    }

    public void setCategoryPageSize(int categoryPageSize) {
        this.categoryPageSize = categoryPageSize;
    }

    public List<ItemCollection> getWorkitems(BoardCategory category) {
        List<ItemCollection> temp = this.cacheTasks.get(category);
        int iStart = category.getPageIndex() * category.getPageSize();
        int iEnd = iStart + category.getPageSize();
        if (iEnd > temp.size()) {
            iEnd = temp.size();
        }
        return temp.subList(iStart, iEnd);
    }

    public boolean isEndOfList(BoardCategory category) {
        List<ItemCollection> temp = this.cacheTasks.get(category);
        int i = (category.getPageIndex() + 1) * category.getPageSize();
        return i >= temp.size();
    }

    private void readWorkList() {
        List taskList;
        long l = System.currentTimeMillis();
        this.cacheTasks = new HashMap<BoardCategory, List<ItemCollection>>();
        String sortBy = this.setupController.getSortBy();
        boolean bReverse = this.setupController.getSortReverse();
        try {
            if (this.getProcessRef().isEmpty()) {
                this.searchController.getSearchFilter().setItemValue("my_requests", (Object)true);
            } else {
                this.searchController.getSearchFilter().setItemValue("ProcessRef", (Object)this.getProcessRef());
            }
            String query = this.searchController.getQuery();
            taskList = this.documentService.findStubs(query, this.getPageSize(), this.getPageIndex(), sortBy, bReverse);
            if (this.pageMax == 0) {
                this.pageMax = this.documentService.countPages(query, this.getPageSize());
            }
        }
        catch (QueryException e) {
            logger.warning("failed to read task list: " + e.getMessage());
            taskList = new ArrayList();
        }
        this.endOfList = taskList.size() < this.pageSize;
        for (ItemCollection workitem : taskList) {
            BoardCategory tmpCat = new BoardCategory(workitem.getItemValueString("$workflowgroup"), workitem.getItemValueString("$workflowstatus"), workitem.getTaskID(), this.getCategoryPageSize());
            List<ItemCollection> tasksByCategory = this.cacheTasks.get(tmpCat);
            if (tasksByCategory == null) {
                tasksByCategory = new ArrayList<ItemCollection>();
            }
            tasksByCategory.add(workitem);
            this.cacheTasks.put(tmpCat, tasksByCategory);
        }
        logger.fine("read worklist in " + (System.currentTimeMillis() - l) + "ms");
    }
}

