/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.marty.config.SetupController;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.office.views.BoardCategory;
import org.imixs.workflow.office.views.BoardController;

@Named
@ViewScoped
public class MonitorController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ItemCollection process = null;
    private List<String> workflowGroups = null;
    private List<String> activeWorkflowGroups = null;
    private Set<BoardCategory> boardCategories;
    @Inject
    protected LoginController loginController = null;
    @Inject
    protected BoardController boardController;
    @Inject
    SetupController setupController;
    private static Logger logger = Logger.getLogger(MonitorController.class.getName());
    @EJB
    ModelService modelService = null;
    @EJB
    DocumentService documentService;
    @EJB
    SchemaService schemaService;

    @PostConstruct
    public void init() {
        FacesContext fc = FacesContext.getCurrentInstance();
        Map paramMap = fc.getExternalContext().getRequestParameterMap();
        this.boardController.setProcessRef((String)paramMap.get("processref"));
        this.reset();
    }

    public String getProcessRef() {
        return this.boardController.getProcessRef();
    }

    public ItemCollection getProcess() {
        return this.process;
    }

    public void setProcess(ItemCollection process) {
        this.process = process;
    }

    public List<String> getWorkflowGroups() {
        return this.workflowGroups;
    }

    public List<String> getActiveWorkflowGroups() {
        return this.activeWorkflowGroups;
    }

    public String getBase64(String key) {
        byte[] data = Base64.getEncoder().encode(key.getBytes());
        String result = new String(data);
        result = result.replace("=", "_");
        return result;
    }

    public Set<BoardCategory> getBoardCategories() {
        return this.boardCategories;
    }

    public void setBoardCategories(Set<BoardCategory> boardCategories) {
        this.boardCategories = boardCategories;
    }

    public void reset() {
        this.workflowGroups = new ArrayList<String>();
        String processRef = this.boardController.getProcessRef();
        if (processRef != null && !processRef.isEmpty()) {
            this.process = this.documentService.load(processRef);
            this.workflowGroups = this.process.getItemValue("txtWorkflowList");
        }
        this.boardCategories = new HashSet<BoardCategory>();
        try {
            this.countWorkList();
        }
        catch (ModelException | QueryException e) {
            logger.severe("failed to reset monitoring board: " + e.getMessage());
        }
        this.activeWorkflowGroups = new ArrayList<String>();
        for (BoardCategory cat : this.boardCategories) {
            if (this.activeWorkflowGroups.contains(cat.getWorkflowGroup())) continue;
            this.activeWorkflowGroups.add(cat.getWorkflowGroup());
        }
    }

    public void refresh() {
    }

    private void countWorkList() throws QueryException, ModelException {
        long l = System.currentTimeMillis();
        String query = "(type:\"workitem\" AND $uniqueidref:\"" + this.getProcessRef() + "\")";
        for (String group : this.workflowGroups) {
            List versions = this.modelService.findVersionsByGroup(group);
            if (versions == null || versions.size() <= 0) continue;
            String version = (String)versions.get(0);
            Model model = this.modelService.getModel(version);
            List tasks = model.findTasksByGroup(group);
            for (ItemCollection task : tasks) {
                int taskID = task.getItemValueInteger("numprocessid");
                String taskName = task.getItemValueString("name");
                String taskQuery = query + " AND ($taskid:" + taskID + " AND $workflowgroup:\"" + group + "\")";
                int count = this.documentService.count(taskQuery);
                if (count <= 0) continue;
                BoardCategory tmpCat = new BoardCategory(group, taskName, taskID, count);
                this.boardCategories.add(tmpCat);
            }
        }
        logger.info("...counted all tasks in " + (System.currentTimeMillis() - l) + "ms");
    }

    public String getOverallData() {
        String result = "{";
        result = result + "labels : [ ";
        result = result + this.workflowGroups.stream().collect(Collectors.joining("','", "'", "'"));
        result = result + "],";
        result = result + " datasets : [ { ";
        result = result + " label : 'All Groups', ";
        ArrayList<String> overAllCount = new ArrayList<String>();
        for (String group : this.workflowGroups) {
            int count = 0;
            for (BoardCategory cat : this.boardCategories) {
                if (!group.equals(cat.getWorkflowGroup())) continue;
                count += cat.pageSize;
            }
            overAllCount.add("" + count);
        }
        result = result + " data: [ " + overAllCount.stream().collect(Collectors.joining(",")) + "],";
        result = result + " backgroundColor : [\n                        'rgb(255, 99, 132)',\n                        'rgb(54, 162, 235)',\n                        'rgb(255, 205, 86)' ]";
        result = result + " } ] }";
        return result;
    }

    public String getGroupData() {
        String result = "[";
        for (String group : this.activeWorkflowGroups) {
            result = result + "{id:'" + this.getBase64(group) + "', name:'" + group + "',";
            result = result + "data:" + this.buildChartData(group) + "},";
        }
        result = result.substring(0, result.length() - 1);
        result = result + "]";
        return result;
    }

    private String buildChartData(String group) {
        ArrayList<String> statusLabels = new ArrayList<String>();
        for (BoardCategory cat : this.boardCategories) {
            if (!group.equals(cat.getWorkflowGroup())) continue;
            statusLabels.add(cat.workflowStatus);
        }
        String result = "{";
        result = result + "labels : [ ";
        result = result + statusLabels.stream().collect(Collectors.joining("','", "'", "'"));
        result = result + "],";
        result = result + " datasets : [ { ";
        result = result + " label : '" + group + "', ";
        ArrayList<String> statusCount = new ArrayList<String>();
        for (BoardCategory cat : this.boardCategories) {
            if (!group.equals(cat.getWorkflowGroup())) continue;
            statusCount.add("" + cat.pageSize);
        }
        result = result + " data: [ " + statusCount.stream().collect(Collectors.joining(",")) + "],";
        result = result + " backgroundColor : [\n                        'rgb(255, 99, 132)',\n                        'rgb(54, 162, 235)',\n                        'rgb(255, 205, 86)' ]";
        result = result + " } ] }";
        return result;
    }
}

