/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.plugins;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;

public class DMSSplitPlugin
extends AbstractPlugin {
    public static String SNAPSHOTID = "$snapshotid";
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String DMS_SUBPROCESS_CREATE = "dms_subprocess_create";
    private static Logger logger = Logger.getLogger(DMSSplitPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(adocumentActivity, "item", adocumentContext);
        if (evalItemCollection == null) {
            return adocumentContext;
        }
        if (evalItemCollection.hasItem(DMS_SUBPROCESS_CREATE)) {
            String processValue;
            logger.fine("processing dms_subprocess_create");
            List processValueList = evalItemCollection.getItemValue(DMS_SUBPROCESS_CREATE);
            if (processValueList == null || processValueList.size() == 0) {
                logger.warning("Invalid DMS_SUBPROCESS_CREATE definition found, please check model!");
                return adocumentContext;
            }
            if (processValueList.size() > 1) {
                logger.warning("More than one DMS_SUBPROCESS_CREATE definitions found, please check model!");
            }
            if ((processValue = (String)processValueList.get(0)).trim().isEmpty()) {
                logger.warning("Invalid DMS_SUBPROCESS_CREATE definition found, please check model!");
                return adocumentContext;
            }
            ItemCollection dmsProcessData = XMLParser.parseItemStructure((String)processValue);
            try {
                adocumentContext = this.createSubprocesses(dmsProcessData, adocumentContext);
            }
            catch (ModelException e) {
                throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
            }
        }
        return adocumentContext;
    }

    private ItemCollection createSubprocesses(ItemCollection processData, ItemCollection originWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        if (processData != null) {
            Map files = null;
            ItemCollection attachmentContext = (ItemCollection)originWorkitem.clone();
            ItemCollection snapshotWorkitem = this.getWorkflowService().getDocumentService().load(originWorkitem.getItemValueString(SNAPSHOTID));
            if (snapshotWorkitem != null) {
                this.copyFilesFromItemCollection(attachmentContext, snapshotWorkitem);
            }
            if (attachmentContext != null) {
                files = attachmentContext.getFiles();
            }
            if (files == null) {
                return originWorkitem;
            }
            for (Map.Entry entry : files.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                logger.fine("create dms_subprocess for " + key);
                ItemCollection workitemSubProcess = new ItemCollection();
                this.copyItemList(processData.getItemValueString("items"), originWorkitem, workitemSubProcess);
                workitemSubProcess.replaceItemValue("$modelversion", (Object)processData.getItemValueString("modelversion"));
                workitemSubProcess.replaceItemValue("$processid", (Object)new Integer(processData.getItemValueString("processid")));
                workitemSubProcess.setEventID(new Integer(processData.getItemValueString("activityid")).intValue());
                workitemSubProcess.replaceItemValue("$uniqueidref", (Object)originWorkitem.getUniqueID());
                byte[] bytes = (byte[])value.get(1);
                workitemSubProcess.addFile(bytes, key, value.get(0).toString());
                workitemSubProcess = this.getWorkflowService().processWorkItem(workitemSubProcess);
                logger.fine("successful created new subprocess.");
                this.addWorkitemRef(workitemSubProcess.getUniqueID(), originWorkitem);
            }
            if (processData.getItemValueBoolean("remove")) {
                for (String filename : files.keySet()) {
                    logger.fine("remove attachment '" + filename + "'");
                    originWorkitem.removeFile(filename);
                }
            }
        }
        return originWorkitem;
    }

    private void copyItemList(String items, ItemCollection source, ItemCollection target) {
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            int pos = field.indexOf(124);
            if (pos > -1) {
                target.replaceItemValue(field.substring(pos + 1).trim(), (Object)source.getItemValue(field.substring(0, pos).trim()));
                continue;
            }
            target.replaceItemValue(field, (Object)source.getItemValue(field));
        }
    }

    private void addWorkitemRef(String aUniqueID, ItemCollection workitem) {
        logger.fine("LinkController add workitem reference: " + aUniqueID);
        List refList = workitem.getItemValue(LINK_PROPERTY);
        if (refList.size() == 1 && "".equals(refList.get(0))) {
            refList.remove(0);
        }
        if (refList.indexOf(aUniqueID) == -1) {
            refList.add(aUniqueID);
            workitem.replaceItemValue(LINK_PROPERTY, (Object)refList);
        }
    }

    private void copyFilesFromItemCollection(ItemCollection currentWorkitem, ItemCollection snaptshotWorkitem) {
        Map files = currentWorkitem.getFiles();
        if (files != null) {
            for (Map.Entry entry : files.entrySet()) {
                List oldFile;
                String fileName = (String)entry.getKey();
                List file = (List)entry.getValue();
                byte[] content = (byte[])file.get(1);
                if (content.length != 0 && content.length > 2 || snaptshotWorkitem == null || (oldFile = snaptshotWorkitem.getFile(fileName)) == null) continue;
                logger.fine("copy file content '" + fileName + "' from: " + currentWorkitem.getUniqueID());
                currentWorkitem.addFile((byte[])oldFile.get(1), fileName, (String)oldFile.get(0));
            }
        }
    }
}

