/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.marty.plugins;

import java.util.logging.Logger;
import javax.ejb.EJB;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.office.util.SequenceService;

public class SequenceNumberPlugin
extends AbstractPlugin {
    private static Logger logger = Logger.getLogger(SequenceNumberPlugin.class.getName());
    public static String NO_SEQUENCE_SERVICE_FOUND = "NO_SEQUENCE_SERVICE_FOUND";
    @EJB
    SequenceService sequenceService = null;

    public ItemCollection run(ItemCollection documentContext, ItemCollection event) throws PluginException {
        String sType = documentContext.getItemValueString("Type");
        if (!sType.equals("workitem")) {
            return documentContext;
        }
        if (documentContext.getItemValueInteger("numsequencenumber") > 0) {
            return documentContext;
        }
        logger.fine("...calculating next sequencenumber: '" + documentContext.getUniqueID() + "'");
        try {
            ItemCollection itemColNextTask;
            if (documentContext.getItemValueString("$workflowgroup").isEmpty() && (itemColNextTask = this.getWorkflowService().evalNextTask(documentContext)) != null) {
                documentContext.replaceItemValue("$workflowgroup", (Object)itemColNextTask.getItemValueString("txtworkflowgroup"));
            }
            this.sequenceService.computeSequenceNumber(documentContext);
        }
        catch (AccessDeniedException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), "calculating next sequencenumber failed: ", (Exception)((Object)e));
        }
        catch (ModelException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), "calculating next sequencenumber failed: ", (Exception)((Object)e));
        }
        return documentContext;
    }
}

